/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.config;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_1163;
import net.minecraft.class_11944;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.WeatherParticleManager;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.config.Whitelist;
import pigcart.particlerain.config.gui.Annotations;
import pigcart.particlerain.particle.CustomParticle;
import pigcart.particlerain.particle.render.BlendedParticleRenderType;

public class ConfigData {
    @Annotations.NoGUI
    public byte configVersion = (byte)5;
    public PerformanceOptions perf = new PerformanceOptions();
    public SoundOptions sound = new SoundOptions();
    public WindOptions wind = new WindOptions();
    public CompatibilityOptions compat = new CompatibilityOptions();
    public ArrayList<ParticleData> particles = new ArrayList<ParticleData>(List.of(new ParticleData("rain", true, 1.0f, Weather.DURING_WEATHER, new ArrayList<class_1959.class_1963>(List.of(class_1959.class_1963.field_9382)), new Whitelist.BiomeList(), new Whitelist.BlockList(), true, SpawnPos.SKY, 0.9f, 0.5f, 1.0f, 0.0f, 1.0f, 1.5f, false, RenderType.TRANSLUCENT, new ArrayList<String>(List.of("particlerain:rain_0", "particlerain:rain_1", "particlerain:rain_2", "particlerain:rain_3")), TintType.WATER, RotationType.RELATIVE_VELOCITY), new ParticleData("snow", true, 0.4f, Weather.DURING_WEATHER, new ArrayList<class_1959.class_1963>(List.of(class_1959.class_1963.field_9383)), new Whitelist.BiomeList(), new Whitelist.BlockList(), true, SpawnPos.SKY, 0.05f, 0.1f, 0.2f, 0.4f, 1.0f, 1.5f, false, RenderType.TRANSLUCENT, new ArrayList<String>(List.of("particlerain:snow_0", "particlerain:snow_1", "particlerain:snow_2", "particlerain:snow_3")), TintType.NONE, RotationType.COPY_CAMERA), new ParticleData("dust", true, 0.8f, Weather.DURING_WEATHER, new ArrayList<class_1959.class_1963>(List.of(class_1959.class_1963.field_9384)), new Whitelist.BiomeList(), new Whitelist.BlockList(true, new ArrayList<String>(List.of("#minecraft:camel_sand_step_sound_blocks", "#minecraft:sand", "#minecraft:terracotta", "#c:sandstone_blocks"))), true, SpawnPos.SKY, 0.2f, 0.7f, 1.0f, 0.0f, 1.0f, 1.5f, false, RenderType.TRANSLUCENT, new ArrayList<String>(List.of("particlerain:dust")), TintType.MAP, RotationType.COPY_CAMERA), new ParticleData("rain_haze", true, 0.1f, Weather.DURING_WEATHER, new ArrayList<class_1959.class_1963>(List.of(class_1959.class_1963.field_9382)), new Whitelist.BiomeList(), new Whitelist.BlockList(), true, SpawnPos.SKY, 0.15f, 0.01f, 0.1f, 0.0f, 0.35f, 0.3f, true, RenderType.TRANSLUCENT, new ArrayList<String>(List.of("particlerain:fog_dithered")), TintType.FOG, RotationType.COPY_CAMERA), new ParticleData("snow_haze", true, 0.2f, Weather.DURING_WEATHER, new ArrayList<class_1959.class_1963>(List.of(class_1959.class_1963.field_9383)), new Whitelist.BiomeList(), new Whitelist.BlockList(), true, SpawnPos.SKY, 0.05f, 0.01f, 0.1f, 0.0f, 0.35f, 0.3f, true, RenderType.TRANSLUCENT, new ArrayList<String>(List.of("particlerain:fog_dithered")), TintType.FOG, RotationType.COPY_CAMERA), new ParticleData("dust_haze", true, 0.1f, Weather.DURING_WEATHER, new ArrayList<class_1959.class_1963>(List.of(class_1959.class_1963.field_9384)), new Whitelist.BiomeList(), new Whitelist.BlockList(true, new ArrayList<String>(List.of("#minecraft:camel_sand_step_sound_blocks", "#minecraft:sand", "#minecraft:terracotta", "#c:sandstone_blocks"))), true, SpawnPos.SKY, 0.1f, 0.25f, 0.5f, 0.0f, 0.35f, 0.3f, true, RenderType.TRANSLUCENT, new ArrayList<String>(List.of("particlerain:fog_dithered")), TintType.MAP, RotationType.COPY_CAMERA), new ParticleData("minecraft:rain", "splatter", true, 1.0f, Weather.DURING_WEATHER, new ArrayList<class_1959.class_1963>(List.of(class_1959.class_1963.field_9382)), new Whitelist.BiomeList(), new Whitelist.BlockList(false, new ArrayList<String>(List.of("minecraft:lava"))), true, SpawnPos.BLOCK_TOP), new ParticleData("particlerain:ripple", "ripple", true, 1.0f, Weather.DURING_WEATHER, new ArrayList<class_1959.class_1963>(List.of(class_1959.class_1963.field_9382)), new Whitelist.BiomeList(), new Whitelist.BlockList(true, new ArrayList<String>(List.of("minecraft:water"))), true, SpawnPos.BLOCK_TOP), new ParticleData("minecraft:smoke", "smoke", true, 1.0f, Weather.DURING_WEATHER, new ArrayList<class_1959.class_1963>(List.of(class_1959.class_1963.field_9382)), new Whitelist.BiomeList(), new Whitelist.BlockList(true, new ArrayList<String>(List.of("#minecraft:strider_warm_blocks", "#minecraft:infiniburn_overworld"))), true, SpawnPos.BLOCK_TOP), new ParticleData("particlerain:streak", "streak", true, 0.2f, Weather.DURING_WEATHER, new ArrayList<class_1959.class_1963>(List.of(class_1959.class_1963.field_9382)), new Whitelist.BiomeList(), new Whitelist.BlockList(true, new ArrayList<String>(List.of("#minecraft:impermeable", "#c:glass_panes", "#minecraft:mineable/pickaxe"))), true, SpawnPos.BLOCK_SIDES), new ParticleData("particlerain:shrub", "shrub", true, 0.002f, Weather.DURING_WEATHER, new ArrayList<class_1959.class_1963>(List.of(class_1959.class_1963.field_9384)), new Whitelist.BiomeList(), new Whitelist.BlockList(true, new ArrayList<String>(List.of("#minecraft:camel_sand_step_sound_blocks", "#minecraft:sand", "#minecraft:terracotta", "#c:sandstone_blocks"))), true, SpawnPos.WORLD_SURFACE), new ParticleData("particlerain:mist", "mist_after_rain", true, 0.1f, Weather.AFTER_WEATHER, new ArrayList<class_1959.class_1963>(List.of(class_1959.class_1963.field_9382)), new Whitelist.BiomeList(), new Whitelist.BlockList(true, new ArrayList<String>(List.of("#minecraft:dirt"))), true, SpawnPos.WORLD_SURFACE), new ParticleData("particlerain:mist", "mist", true, 0.1f, Weather.ALWAYS, new ArrayList<class_1959.class_1963>(List.of(class_1959.class_1963.field_9382)), new Whitelist.BiomeList(true, new ArrayList<String>(List.of("#c:is_wet/overworld", "#c:is_spooky"))), new Whitelist.BlockList(true, new ArrayList<String>(List.of("#minecraft:dirt"))), true, SpawnPos.WORLD_SURFACE)));
    @Annotations.NoGUI
    public ShrubOptions shrub = new ShrubOptions();
    @Annotations.NoGUI
    public RippleOptions ripple = new RippleOptions();
    @Annotations.NoGUI
    public StreakOptions streak = new StreakOptions();
    @Annotations.NoGUI
    public MistOptions mist = new MistOptions();

    public static class PerformanceOptions {
        @Annotations.OnChange(value=ConfigManager.ClearParticles.class)
        public int maxParticleAmount = 1500;
        public int particleDensity = 100;
        public int particleStormDensity = 200;
        public int particleDistance = 16;
        public int surfaceRange = 64;
    }

    public static class SoundOptions {
        @Annotations.Slider
        @Annotations.Format(value=ConfigManager.PercentOrOff.class)
        public float rainVolume = 0.2f;
        @Annotations.Slider
        @Annotations.Format(value=ConfigManager.PercentOrOff.class)
        public float snowVolume = 0.1f;
        @Annotations.Slider
        @Annotations.Format(value=ConfigManager.PercentOrOff.class)
        public float windVolume = 0.1f;
        @Annotations.Slider
        @Annotations.Format(value=ConfigManager.PercentOrOff.class)
        public float blockVolume = 0.07f;
    }

    public static class WindOptions {
        public float strength = 0.4f;
        public float strengthVariance = 0.3f;
        public float gustFrequency = 0.2f;
        public float modulationSpeed = 0.04f;
        public boolean yLevelAdjustment = true;
    }

    public static class CompatibilityOptions {
        public boolean renderDefaultWeather = false;
        public boolean doDefaultSplashing = false;
        @Annotations.OnChange(value=ConfigManager.ReloadResources.class)
        public boolean waterTint = true;
        @Annotations.Slider
        @Annotations.Format(value=ConfigManager.Percent.class)
        public float tintMix = 0.6f;
        @Annotations.NoGUI
        public boolean shaderpackTint = true;
        public boolean syncRegistries = true;
        public boolean crossBiomeBorder = false;
        public boolean useHeightmapTemp = true;
        public boolean doSpawnHeightLimit = true;
        @Annotations.Format(value=ConfigManager.ZeroIsAutomatic.class)
        public int spawnHeightLimit = 0;
    }

    public static class ParticleData {
        @Annotations.OnlyVisibleIf(value=ConfigManager.ParticleNotCustom.class)
        public String presetParticleId = "minecraft:flame";
        @Annotations.NoGUI
        public transient class_2394 presetParticle = class_2398.field_11204;
        @Annotations.OnChange(value=ConfigManager.RefreshScreen.class)
        public boolean usePresetParticle = false;
        @Annotations.OnlyVisibleIf(value=ConfigManager.ParticleIsNotDefault.class)
        public String id = "new_particle";
        @Annotations.Label(key="spawning")
        public boolean enabled = true;
        @Annotations.Slider(step=0.001f)
        @Annotations.Format(value=ConfigManager.Percent.class)
        public float density = 1.0f;
        public Weather weather = Weather.DURING_WEATHER;
        public ArrayList<class_1959.class_1963> precipitation = new ArrayList<class_1959.class_1963>(List.of(class_1959.class_1963.field_9382));
        public Whitelist.BiomeList biomeList = new Whitelist.BiomeList(true, new ArrayList<String>(1));
        public Whitelist.BlockList blockList = new Whitelist.BlockList(true, new ArrayList<String>(1));
        public boolean needsSkyAccess = false;
        public SpawnPos spawnPos = SpawnPos.SKY;
        @Annotations.Label(key="motion")
        @Annotations.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public float gravity = 0.9f;
        @Annotations.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public float windStrength = 0.5f;
        @Annotations.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public float stormWindStrength = 1.0f;
        @Annotations.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public float rotationAmount = 0.0f;
        @Annotations.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public int lifetime = 3000;
        @Annotations.Label(key="appearance")
        @Annotations.Slider
        @Annotations.Format(value=ConfigManager.Percent.class)
        @Annotations.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public float opacity = 0.9f;
        @Annotations.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public float size = 0.5f;
        @Annotations.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public boolean constantScreenSize = false;
        @Annotations.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public RenderType renderType = RenderType.TRANSLUCENT;
        @Annotations.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public ArrayList<String> spriteLocations = new ArrayList<String>(List.of("particlerain:rain_0", "particlerain:rain_1", "particlerain:rain_2", "particlerain:rain_3"));
        @Annotations.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        @Annotations.OnChange(value=ConfigManager.RefreshScreen.class)
        public TintType tintType = TintType.NONE;
        @Annotations.OnlyVisibleIf(value=ConfigManager.ParticleIsCustomAndAlsoUsesCustomTint.class)
        public Color customTint = Color.BLACK;
        @Annotations.OnlyVisibleIf(value=ConfigManager.ParticleIsCustom.class)
        public RotationType rotationType = RotationType.COPY_CAMERA;

        public ParticleData() {
        }

        ParticleData(String particle, String id, boolean enabled, float density, Weather weather, ArrayList<class_1959.class_1963> precipitation, Whitelist.BiomeList biomeList, Whitelist.BlockList blockList, boolean needsSkyAccess, SpawnPos spawnPos) {
            this.presetParticleId = particle;
            this.usePresetParticle = true;
            this.id = id;
            this.enabled = enabled;
            this.density = density;
            this.weather = weather;
            this.precipitation = precipitation;
            this.biomeList = biomeList;
            this.blockList = blockList;
            this.needsSkyAccess = needsSkyAccess;
            this.spawnPos = spawnPos;
        }

        public ParticleData(String id, boolean enabled, float density, Weather weather, ArrayList<class_1959.class_1963> precipitation, Whitelist.BiomeList biomeList, Whitelist.BlockList blockList, boolean needsSkyAccess, SpawnPos spawnPos, float gravity, float windStrength, float stormWindStrength, float rotationAmount, float opacity, float size, boolean constantScreenSize, RenderType renderType, ArrayList<String> spriteLocations, TintType tintType, RotationType rotationType) {
            this.id = id;
            this.enabled = enabled;
            this.density = density;
            this.weather = weather;
            this.precipitation = precipitation;
            this.biomeList = biomeList;
            this.blockList = blockList;
            this.needsSkyAccess = needsSkyAccess;
            this.spawnPos = spawnPos;
            this.gravity = gravity;
            this.windStrength = windStrength;
            this.stormWindStrength = stormWindStrength;
            this.rotationAmount = rotationAmount;
            this.opacity = opacity;
            this.size = size;
            this.constantScreenSize = constantScreenSize;
            this.renderType = renderType;
            this.spriteLocations = spriteLocations;
            this.tintType = tintType;
            this.rotationType = rotationType;
        }

        public void setPresetParticle() {
            Optional optional = class_7923.field_41180.method_17966(VersionUtil.parseId(this.presetParticleId));
            if (optional.isEmpty()) {
                ParticleRain.LOGGER.error("Incorrect configuration: {} is not a valid particle", (Object)this.presetParticleId);
            } else {
                this.presetParticle = (class_2394)optional.get();
            }
        }
    }

    public static enum Weather {
        DURING_WEATHER{

            @Override
            public boolean isCurrent(class_638 level) {
                return level.method_8419();
            }
        }
        ,
        ONLY_DURING_NORMAL_WEATHER{

            @Override
            public boolean isCurrent(class_638 level) {
                return level.method_8419() && !level.method_8546();
            }
        }
        ,
        ONLY_DURING_STORMY_WEATHER{

            @Override
            public boolean isCurrent(class_638 level) {
                return level.method_8546();
            }
        }
        ,
        AFTER_WEATHER{

            @Override
            public boolean isCurrent(class_638 level) {
                return WeatherParticleManager.afterWeatherTicksLeft > 0;
            }
        }
        ,
        CLEAR{

            @Override
            public boolean isCurrent(class_638 level) {
                return !level.method_8419();
            }
        }
        ,
        ALWAYS;


        public boolean isCurrent(class_638 level) {
            return true;
        }
    }

    public static enum SpawnPos {
        SKY,
        BLOCK_SIDES,
        BLOCK_BOTTOM,
        BLOCK_TOP,
        WORLD_SURFACE;

    }

    public static enum RenderType {
        OPAQUE{

            @Override
            public class_3940.class_11941 get() {
                return class_3940.class_11941.field_62640;
            }
        }
        ,
        TRANSLUCENT{

            @Override
            public class_3940.class_11941 get() {
                return class_3940.class_11941.field_62641;
            }
        }
        ,
        BLENDED;


        public class_3940.class_11941 get() {
            return BlendedParticleRenderType.INSTANCE;
        }
    }

    public static enum TintType {
        WATER{

            @Override
            public void applyTint(class_3940 p, class_638 level, class_2338 pos, ParticleData opts) {
                Color waterColor = new Color(class_1163.method_4961((class_1920)level, (class_2338)pos));
                Color fogColor = VersionUtil.getFogColor((class_1937)level, pos);
                float rCol = class_3532.method_16439((float)ConfigManager.config.compat.tintMix, (float)waterColor.getRed(), (float)fogColor.getRed());
                float gCol = class_3532.method_16439((float)ConfigManager.config.compat.tintMix, (float)waterColor.getGreen(), (float)fogColor.getGreen());
                float bCol = class_3532.method_16439((float)ConfigManager.config.compat.tintMix, (float)waterColor.getBlue(), (float)fogColor.getBlue());
                p.method_74305(rCol / 255.0f, gCol / 255.0f, bCol / 255.0f);
            }
        }
        ,
        FOG{

            @Override
            public void applyTint(class_3940 p, class_638 level, class_2338 pos, ParticleData opts) {
                Color color = VersionUtil.getFogColor((class_1937)level, pos).darker();
                p.method_74305((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            }
        }
        ,
        MAP{

            @Override
            public void applyTint(class_3940 p, class_638 level, class_2338 pos, ParticleData opts) {
                Color color = VersionUtil.getMapColor(level, pos);
                p.method_74305((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            }
        }
        ,
        CUSTOM{

            @Override
            public void applyTint(class_3940 p, class_638 level, class_2338 pos, ParticleData opts) {
                p.method_74305((float)opts.customTint.getRed() / 255.0f, (float)opts.customTint.getGreen() / 255.0f, (float)opts.customTint.getBlue() / 255.0f);
            }
        }
        ,
        NONE;


        public void applyTint(class_3940 p, class_638 level, class_2338 pos, ParticleData opts) {
        }
    }

    public static enum RotationType {
        COPY_CAMERA{

            @Override
            public void render(class_11944 h, class_4184 camera, float tickPercent, CustomParticle p) {
                p.renderCameraCopyQuad(h, camera, tickPercent);
            }
        }
        ,
        RELATIVE_VELOCITY{

            @Override
            public void render(class_11944 h, class_4184 camera, float tickPercent, CustomParticle p) {
                p.renderRelativeVelocityQuad(h, camera, tickPercent);
            }
        }
        ,
        WORLD_VELOCITY{

            @Override
            public void render(class_11944 h, class_4184 camera, float tickPercent, CustomParticle p) {
                p.renderWorldVelocityQuad(h, camera, tickPercent);
            }
        }
        ,
        LOOKAT_PLAYER{

            @Override
            public void render(class_11944 h, class_4184 camera, float tickPercent, CustomParticle p) {
                p.renderLookingQuad(h, camera, tickPercent);
            }
        };


        public void render(class_11944 h, class_4184 camera, float tickPercent, CustomParticle p) {
        }
    }

    public static class ShrubOptions {
        public float gravity = 0.2f;
        public float windStrength = 0.2f;
        public float stormWindStrength = 0.3f;
        public float size = 0.5f;
        public float rotationAmount = 0.6f;
        public float bounciness = 0.2f;
    }

    public static class RippleOptions {
        @Annotations.Slider
        @Annotations.Format(value=ConfigManager.Percent.class)
        public float opacity = 0.8f;
        public float size = 0.25f;
        @Annotations.OnChange(value=ConfigManager.ReloadResources.class)
        public int resolution = 16;
        @Annotations.OnChange(value=ConfigManager.ReloadResources.class)
        public boolean useResourcepackResolution = true;
    }

    public static class StreakOptions {
        @Annotations.Slider
        @Annotations.Format(value=ConfigManager.Percent.class)
        public float opacity = 0.9f;
        public float size = 0.5f;
    }

    public static class MistOptions {
        public int lifetime = 200;
        @Annotations.Slider
        @Annotations.Format(value=ConfigManager.Percent.class)
        public float opacity = 1.0f;
        public float size = 3.0f;
        public RenderStyle renderStyle = RenderStyle.BLENDED;

        public static enum RenderStyle {
            BLENDED{

                @Override
                public class_1058 getSprite() {
                    return VersionUtil.getSprite(VersionUtil.getId("fog_translucent"));
                }

                @Override
                public class_3940.class_11941 getRenderType() {
                    return BlendedParticleRenderType.INSTANCE;
                }
            }
            ,
            DITHERED;


            public class_1058 getSprite() {
                return VersionUtil.getSprite(VersionUtil.getId("fog_dithered"));
            }

            public class_3940.class_11941 getRenderType() {
                return class_3940.class_11941.field_62641;
            }
        }
    }
}

