/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.api.internal;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.enums.config.EDhApiMcRenderingFadeMode;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiDebugRendering;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiRenderPass;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiRendererMode;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiAfterRenderEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeDeferredRenderEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeRenderEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiLevelLoadEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiLevelUnloadEvent;
import com.seibel.distanthorizons.core.api.internal.ClientPluginChannelApi;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.api.internal.rendering.DhRenderState;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.enums.EMinecraftColor;
import com.seibel.distanthorizons.core.level.IServerKeyedClientLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.network.messages.AbstractNetworkMessage;
import com.seibel.distanthorizons.core.network.session.NetworkSession;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.render.DhApiRenderProxy;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.render.renderer.RenderParams;
import com.seibel.distanthorizons.core.render.renderer.TestRenderer;
import com.seibel.distanthorizons.core.render.renderer.VanillaFadeRenderer;
import com.seibel.distanthorizons.core.util.TimerUtil;
import com.seibel.distanthorizons.core.util.objects.Pair;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.world.DhClientWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientApi {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    public static boolean prefLoggerEnabled = false;
    public static final ClientApi INSTANCE = new ClientApi();
    public static final TestRenderer TEST_RENDERER = new TestRenderer();
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final int MS_BETWEEN_STATIC_STARTUP_MESSAGES = 4000;
    public static final DhRenderState RENDER_STATE = new DhRenderState();
    private boolean isDevBuildMessagePrinted = false;
    private boolean lowMemoryWarningPrinted = false;
    private boolean highVanillaRenderDistanceWarningPrinted = false;
    private long lastStaticWarningMessageSentMsTime = 0L;
    private final Queue<String> chatMessageQueueForNextFrame = new LinkedBlockingQueue<String>();
    private final Queue<String> overlayMessageQueueForNextFrame = new LinkedBlockingQueue<String>();
    public boolean rendererDisabledBecauseOfExceptions = false;
    private final ClientPluginChannelApi pluginChannelApi = new ClientPluginChannelApi(this::clientLevelLoadEvent, this::clientLevelUnloadEvent);
    private Timer firstLevelLoadTimer;
    private static final long FIRST_LEVEL_LOAD_DELAY_IN_MS = 1000L;
    public final HashSet<IClientLevelWrapper> waitingClientLevels = new HashSet();
    public final HashMap<Pair<IClientLevelWrapper, DhChunkPos>, IChunkWrapper> waitingChunkByClientLevelAndPos = new HashMap();
    @Nullable
    public String lastRenderParamValidationMessage = null;

    private ClientApi() {
    }

    public synchronized void onClientOnlyConnected() {
        boolean connectedToServer = MC_CLIENT.clientConnectedToDedicatedServer();
        boolean connectedToReplay = MC_CLIENT.connectedToReplay();
        if (connectedToServer || connectedToReplay) {
            if (connectedToServer) {
                LOGGER.info("Client on ClientOnly mode connecting.", new Object[0]);
            } else {
                LOGGER.info("Replay on ClientServer mode connecting.", new Object[0]);
                if (Config.Common.Logging.Warning.showReplayWarningOnStartup.get().booleanValue()) {
                    MC_CLIENT.sendChatMessage((Object)((Object)EMinecraftColor.ORANGE) + "Distant Horizons: Replay detected." + (Object)((Object)EMinecraftColor.CLEAR_FORMATTING));
                    MC_CLIENT.sendChatMessage("DH may behave strangely or have missing functionality.");
                    MC_CLIENT.sendChatMessage("In order to use pre-generated LODs, put your DH database(s) in:");
                    MC_CLIENT.sendChatMessage((Object)((Object)EMinecraftColor.GRAY) + ".Minecraft" + File.separator + "Distant_Horizons_server_data" + File.separator + "REPLAY" + File.separator + "DIMENSION_NAME" + (Object)((Object)EMinecraftColor.CLEAR_FORMATTING));
                    MC_CLIENT.sendChatMessage("This can be disabled in DH's config under Advanced -> Logging.");
                    MC_CLIENT.sendChatMessage("");
                }
            }
            DhClientWorld world = new DhClientWorld();
            SharedApi.setDhWorld(world);
            this.pluginChannelApi.onJoinServer(world.networkState.getSession());
            world.networkState.sendConfigMessage();
            LOGGER.info("Loading [" + this.waitingClientLevels.size() + "] waiting client level wrappers.", new Object[0]);
            for (IClientLevelWrapper level : this.waitingClientLevels) {
                this.clientLevelLoadEvent(level);
            }
            this.waitingClientLevels.clear();
        }
    }

    public synchronized void onClientOnlyDisconnected() {
        AbstractDhWorld world;
        if (this.firstLevelLoadTimer != null) {
            this.firstLevelLoadTimer.cancel();
            this.firstLevelLoadTimer = null;
        }
        if ((world = SharedApi.getAbstractDhWorld()) != null) {
            LOGGER.info("Client on ClientOnly mode disconnecting.", new Object[0]);
            world.close();
            SharedApi.setDhWorld(null);
        }
        this.pluginChannelApi.reset();
        this.waitingChunkByClientLevelAndPos.clear();
        this.waitingClientLevels.clear();
    }

    public void clientLevelUnloadEvent(IClientLevelWrapper level) {
        try {
            AbstractDhWorld world;
            LOGGER.info("Unloading client level [" + level.getClass().getSimpleName() + "]-[" + level.getDhIdentifier() + "].", new Object[0]);
            if (level instanceof IServerKeyedClientLevel) {
                this.pluginChannelApi.onClientLevelUnload();
            }
            if ((world = SharedApi.getAbstractDhWorld()) != null) {
                world.unloadLevel(level);
                SharedApi.INSTANCE.clearQueuedChunkUpdates();
                ApiEventInjector.INSTANCE.fireAllEvents(DhApiLevelUnloadEvent.class, new DhApiLevelUnloadEvent.EventParam(level));
            } else {
                this.waitingClientLevels.remove(level);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error in ClientApi.clientLevelUnloadEvent(), error: " + e.getMessage(), e);
        }
    }

    public void clientLevelLoadEvent(final @Nullable IClientLevelWrapper levelWrapper) {
        if (MC_CLIENT.clientConnectedToDedicatedServer()) {
            if (this.firstLevelLoadTimer == null) {
                this.firstLevelLoadTimer = TimerUtil.CreateTimer("FirstLevelLoadTimer");
                this.firstLevelLoadTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        ClientApi.this.clientLevelLoadEvent(levelWrapper);
                    }
                }, 1000L);
                return;
            }
            this.firstLevelLoadTimer.cancel();
        }
        try {
            LOGGER.info("Loading client level [" + levelWrapper + "]-[" + levelWrapper.getDhIdentifier() + "].", new Object[0]);
            AbstractDhWorld world = SharedApi.getAbstractDhWorld();
            if (world != null) {
                if (!this.pluginChannelApi.allowLevelLoading(levelWrapper)) {
                    LOGGER.info("Levels in this connection are managed by the server, skipping auto-load.", new Object[0]);
                    ((DhClientWorld)world).networkState.sendConfigMessage();
                    return;
                }
                world.getOrLoadLevel(levelWrapper);
                ApiEventInjector.INSTANCE.fireAllEvents(DhApiLevelLoadEvent.class, new DhApiLevelLoadEvent.EventParam(levelWrapper));
                this.loadWaitingChunksForLevel(levelWrapper);
            } else {
                this.waitingClientLevels.add(levelWrapper);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error in ClientApi.clientLevelLoadEvent(), error: " + e.getMessage(), e);
        }
    }

    private void loadWaitingChunksForLevel(IClientLevelWrapper level) {
        HashSet<Pair<IClientLevelWrapper, DhChunkPos>> keysToRemove = new HashSet<Pair<IClientLevelWrapper, DhChunkPos>>();
        for (Pair<IClientLevelWrapper, DhChunkPos> levelChunkPair : this.waitingChunkByClientLevelAndPos.keySet()) {
            IClientLevelWrapper levelWrapper = (IClientLevelWrapper)levelChunkPair.first;
            if (!levelWrapper.equals(level)) continue;
            IChunkWrapper chunkWrapper = this.waitingChunkByClientLevelAndPos.get(levelChunkPair);
            SharedApi.INSTANCE.chunkLoadEvent(chunkWrapper, levelWrapper);
            keysToRemove.add(levelChunkPair);
        }
        LOGGER.info("Loaded [" + keysToRemove.size() + "] waiting chunk wrappers.", new Object[0]);
        for (Pair<IClientLevelWrapper, DhChunkPos> keyToRemove : keysToRemove) {
            this.waitingChunkByClientLevelAndPos.remove(keyToRemove);
        }
    }

    public void pluginMessageReceived(@NotNull AbstractNetworkMessage message) {
        NetworkSession networkSession = this.pluginChannelApi.networkSession;
        if (networkSession != null) {
            networkSession.tryHandleMessage(message);
        }
    }

    public void renderLods() {
        this.renderLodLayer(false);
    }

    public void renderDeferredLodsForShaders() {
        this.renderLodLayer(true);
    }

    private void renderLodLayer(boolean renderingDeferredLayer) {
        this.sendQueuedChatMessages();
        IProfilerWrapper profiler = MC_CLIENT.getProfiler();
        profiler.pop();
        profiler.push("DH-RenderLevel");
        if (!renderingDeferredLayer) {
            profiler.push("DH render thread tasks");
            try {
                GLProxy.getInstance();
                GLProxy.runRenderThreadTasks();
            }
            catch (Exception e) {
                LOGGER.error("Unexpected issue running render thread tasks, error: [" + e.getMessage() + "].", e);
            }
            profiler.pop();
        }
        EDhApiRenderPass renderPass = DhApiRenderProxy.INSTANCE.getDeferTransparentRendering() ? (renderingDeferredLayer ? EDhApiRenderPass.TRANSPARENT : EDhApiRenderPass.OPAQUE) : EDhApiRenderPass.OPAQUE_AND_TRANSPARENT;
        RenderParams renderParams = new RenderParams(renderPass, ClientApi.RENDER_STATE.frameTime, ClientApi.RENDER_STATE.mcProjectionMatrix, ClientApi.RENDER_STATE.mcModelViewMatrix, ClientApi.RENDER_STATE.clientLevelWrapper);
        String validationMessage = renderParams.getValidationErrorMessage();
        if (validationMessage != null) {
            this.lastRenderParamValidationMessage = validationMessage;
            return;
        }
        this.lastRenderParamValidationMessage = null;
        if (this.rendererDisabledBecauseOfExceptions) {
            if (!Config.Client.quickEnableRendering.get().booleanValue()) {
                LOGGER.info("DH Renderer re-enabled after exception. Some rendering issues may occur. Please reboot Minecraft if you see any rendering issues.", new Object[0]);
                this.rendererDisabledBecauseOfExceptions = false;
                Config.Client.quickEnableRendering.set(true);
            }
            return;
        }
        try {
            if (!renderingDeferredLayer) {
                if (Config.Client.Advanced.Debugging.rendererMode.get() == EDhApiRendererMode.DEFAULT) {
                    boolean renderingCancelledForThisFrame = ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeRenderEvent.class, renderParams);
                    if (!renderingCancelledForThisFrame) {
                        LodRenderer.INSTANCE.render(renderParams, profiler);
                    }
                    if (!DhApi.Delayed.renderProxy.getDeferTransparentRendering()) {
                        ApiEventInjector.INSTANCE.fireAllEvents(DhApiAfterRenderEvent.class, null);
                    }
                } else if (Config.Client.Advanced.Debugging.rendererMode.get() == EDhApiRendererMode.DEBUG) {
                    profiler.push("Render Debug");
                    TEST_RENDERER.render();
                    profiler.pop();
                }
            } else {
                boolean renderingCancelled = ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeDeferredRenderEvent.class, renderParams);
                if (!renderingCancelled) {
                    LodRenderer.INSTANCE.renderDeferred(renderParams, profiler);
                }
                if (DhApi.Delayed.renderProxy.getDeferTransparentRendering()) {
                    ApiEventInjector.INSTANCE.fireAllEvents(DhApiAfterRenderEvent.class, null);
                }
            }
        }
        catch (Exception e) {
            this.rendererDisabledBecauseOfExceptions = true;
            LOGGER.error("Unexpected Renderer error in render pass [" + (Object)((Object)renderPass) + "]. Error: " + e.getMessage(), e);
            MC_CLIENT.sendChatMessage((Object)((Object)EMinecraftColor.DARK_RED) + "" + (Object)((Object)EMinecraftColor.BOLD) + "ERROR: Distant Horizons renderer has encountered an exception!" + (Object)((Object)EMinecraftColor.CLEAR_FORMATTING));
            MC_CLIENT.sendChatMessage((Object)((Object)EMinecraftColor.DARK_RED) + "Renderer disabled to try preventing GL state corruption." + (Object)((Object)EMinecraftColor.CLEAR_FORMATTING));
            MC_CLIENT.sendChatMessage((Object)((Object)EMinecraftColor.DARK_RED) + "Toggle DH rendering via the config UI to re-activate DH rendering." + (Object)((Object)EMinecraftColor.CLEAR_FORMATTING));
            MC_CLIENT.sendChatMessage((Object)((Object)EMinecraftColor.DARK_RED) + "Error: " + (Object)((Object)EMinecraftColor.CLEAR_FORMATTING) + e);
        }
        profiler.pop();
        profiler.push("terrain");
    }

    public void renderFadeOpaque() {
        if (Config.Client.Advanced.Debugging.rendererMode.get() == EDhApiRendererMode.DEFAULT && (Config.Client.Advanced.Graphics.Quality.vanillaFadeMode.get() == EDhApiMcRenderingFadeMode.DOUBLE_PASS || Config.Client.Advanced.Debugging.lodOnlyMode.get().booleanValue()) && !DhApiRenderProxy.INSTANCE.getDeferTransparentRendering()) {
            VanillaFadeRenderer.INSTANCE.render(ClientApi.RENDER_STATE.mcModelViewMatrix, ClientApi.RENDER_STATE.mcProjectionMatrix, ClientApi.RENDER_STATE.frameTime, ClientApi.RENDER_STATE.clientLevelWrapper);
        }
    }

    public void renderFadeTransparent() {
        if (Config.Client.Advanced.Debugging.rendererMode.get() == EDhApiRendererMode.DEFAULT) {
            boolean renderFade;
            boolean bl = renderFade = (Config.Client.Advanced.Graphics.Quality.vanillaFadeMode.get() != EDhApiMcRenderingFadeMode.NONE || Config.Client.Advanced.Debugging.lodOnlyMode.get() != false) && !DhApiRenderProxy.INSTANCE.getDeferTransparentRendering();
            if (renderFade) {
                VanillaFadeRenderer.INSTANCE.render(ClientApi.RENDER_STATE.mcModelViewMatrix, ClientApi.RENDER_STATE.mcProjectionMatrix, ClientApi.RENDER_STATE.frameTime, ClientApi.RENDER_STATE.clientLevelWrapper);
            }
        }
    }

    public void keyPressedEvent(int glfwKey) {
        if (!Config.Client.Advanced.Debugging.enableDebugKeybindings.get().booleanValue()) {
            return;
        }
        if (glfwKey == 297) {
            Config.Client.Advanced.Debugging.debugRendering.set(EDhApiDebugRendering.next(Config.Client.Advanced.Debugging.debugRendering.get()));
            MC_CLIENT.sendChatMessage("F8: Set debug mode to " + (Object)((Object)Config.Client.Advanced.Debugging.debugRendering.get()));
        } else if (glfwKey == 295) {
            Config.Client.Advanced.Debugging.rendererMode.set(EDhApiRendererMode.next(Config.Client.Advanced.Debugging.rendererMode.get()));
            MC_CLIENT.sendChatMessage("F6: Set rendering to " + (Object)((Object)Config.Client.Advanced.Debugging.rendererMode.get()));
        } else if (glfwKey == 80) {
            prefLoggerEnabled = !prefLoggerEnabled;
            MC_CLIENT.sendChatMessage("P: Debug Pref Logger is " + (prefLoggerEnabled ? "enabled" : "disabled"));
        }
    }

    private void sendQueuedChatMessages() {
        String message;
        this.detectAndSendBootTimeWarnings();
        if (this.staticStartupMessageSentRecently()) {
            return;
        }
        while (!this.chatMessageQueueForNextFrame.isEmpty()) {
            message = this.chatMessageQueueForNextFrame.poll();
            if (message == null) {
                message = "";
            }
            MC_CLIENT.sendChatMessage(message);
        }
        while (!this.overlayMessageQueueForNextFrame.isEmpty()) {
            message = this.overlayMessageQueueForNextFrame.poll();
            if (message == null) {
                message = "";
            }
            MC_CLIENT.sendOverlayMessage(message);
        }
    }

    private void detectAndSendBootTimeWarnings() {
        String message;
        if (ModInfo.IS_DEV_BUILD && !this.isDevBuildMessagePrinted && MC_CLIENT.playerExists()) {
            this.isDevBuildMessagePrinted = true;
            this.lastStaticWarningMessageSentMsTime = System.currentTimeMillis();
            message = (Object)((Object)EMinecraftColor.DARK_GREEN) + "Distant Horizons: nightly/unstable build, version: [" + "2.4.5-b" + "]." + (Object)((Object)EMinecraftColor.CLEAR_FORMATTING) + "\nIssues may occur with this version.\nHere be dragons!\n";
            MC_CLIENT.sendChatMessage(message);
        }
        if (this.staticStartupMessageSentRecently()) {
            return;
        }
        if (!this.lowMemoryWarningPrinted && Config.Common.Logging.Warning.showLowMemoryWarningOnStartup.get().booleanValue()) {
            this.lowMemoryWarningPrinted = true;
            this.lastStaticWarningMessageSentMsTime = System.currentTimeMillis();
            long minimumRecommendedMemoryInBytes = 4000000000L;
            long maxMemoryInBytes = Runtime.getRuntime().maxMemory();
            if (maxMemoryInBytes < minimumRecommendedMemoryInBytes) {
                String message2 = (Object)((Object)EMinecraftColor.ORANGE) + "Distant Horizons: Low memory detected." + (Object)((Object)EMinecraftColor.CLEAR_FORMATTING) + "\nStuttering or low FPS may occur. \nPlease increase Minecraft's available memory to 4 GB or more. \nThis warning can be disabled in DH's config under Advanced -> Logging. \n";
                MC_CLIENT.sendChatMessage(message2);
            }
        }
        if (this.staticStartupMessageSentRecently()) {
            return;
        }
        if (!this.highVanillaRenderDistanceWarningPrinted && Config.Common.Logging.Warning.showHighVanillaRenderDistanceWarning.get().booleanValue()) {
            this.highVanillaRenderDistanceWarningPrinted = true;
            if (MC_RENDER.getRenderDistance() > 12) {
                this.lastStaticWarningMessageSentMsTime = System.currentTimeMillis();
                message = (Object)((Object)EMinecraftColor.YELLOW) + "Distant Horizons: High vanilla render distance detected." + (Object)((Object)EMinecraftColor.CLEAR_FORMATTING) + "\nUsing a high vanilla render distance uses a lot of CPU power \nand doesn't improve graphics much after about 12.\nLowing your vanilla render distance will give you better FPS\nand reduce stuttering at a similar visual quality.\n" + (Object)((Object)EMinecraftColor.GRAY) + "A vanilla render distance of 8 is recommended." + (Object)((Object)EMinecraftColor.CLEAR_FORMATTING) + "\nThis message can be disabled in DH's config under Advanced -> Logging.\n";
                MC_CLIENT.sendChatMessage(message);
            }
        }
    }

    private boolean staticStartupMessageSentRecently() {
        if (this.lastStaticWarningMessageSentMsTime == 0L) {
            return false;
        }
        long timeSinceLastMessage = System.currentTimeMillis() - this.lastStaticWarningMessageSentMsTime;
        return timeSinceLastMessage <= 4000L;
    }

    public void showChatMessageNextFrame(String chatMessage) {
        this.chatMessageQueueForNextFrame.add(chatMessage);
    }

    public void showOverlayMessageNextFrame(String message) {
        this.overlayMessageQueueForNextFrame.add(message);
    }
}

