/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.neoforge.wrappers;

import com.mojang.blaze3d.textures.GpuTexture;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.neoforge.wrappers.NeoforgeTextureUnwrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.minecraft.MinecraftRenderWrapper;
import net.minecraft.client.Minecraft;

public class NeoforgeMinecraftRenderWrapper
extends MinecraftRenderWrapper {
    public static final NeoforgeMinecraftRenderWrapper INSTANCE = new NeoforgeMinecraftRenderWrapper();
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final Minecraft MC = Minecraft.getInstance();

    @Override
    public int getDepthTextureId() {
        try {
            GpuTexture gpuTexture = this.getRenderTarget().getDepthTexture();
            int id = NeoforgeTextureUnwrapper.getGlTextureIdFromGpuTexture(gpuTexture);
            return id;
        }
        catch (Exception e) {
            if (!this.depthTextureCastFailLogged) {
                this.depthTextureCastFailLogged = true;
                LOGGER.error("Unable to cast render Target depth texture to GlTexture. MC or a rendering mod may have changed the object type.", e);
            }
            return 0;
        }
    }

    @Override
    public int getColorTextureId() {
        try {
            GpuTexture gpuTexture = this.getRenderTarget().getColorTexture();
            int id = NeoforgeTextureUnwrapper.getGlTextureIdFromGpuTexture(gpuTexture);
            return id;
        }
        catch (Exception e) {
            if (!this.colorTextureCastFailLogged) {
                this.colorTextureCastFailLogged = true;
                LOGGER.error("Unable to cast render Target color texture to ValidationGpuTexture or GlTexture. MC, Neoforge, or a rendering mod may have changed the object type.", e);
            }
            return 0;
        }
    }
}

