/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.BlockInputStream;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.IndexIndicatorException;
import org.tukaani.xz.XZIOException;
import org.tukaani.xz.check.Check;
import org.tukaani.xz.common.DecoderUtil;
import org.tukaani.xz.common.StreamFlags;
import org.tukaani.xz.index.IndexHash;

public class SingleXZInputStream
extends InputStream {
    private InputStream in;
    private final ArrayCache arrayCache;
    private final int memoryLimit;
    private final StreamFlags streamHeaderFlags;
    private final Check check;
    private final boolean verifyCheck;
    private BlockInputStream blockDecoder = null;
    private final IndexHash indexHash = new IndexHash();
    private boolean endReached = false;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];

    private static byte[] readStreamHeader(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[12];
        new DataInputStream(inputStream).readFully(byArray);
        return byArray;
    }

    public SingleXZInputStream(InputStream inputStream) throws IOException {
        this(inputStream, -1);
    }

    public SingleXZInputStream(InputStream inputStream, ArrayCache arrayCache) throws IOException {
        this(inputStream, -1, arrayCache);
    }

    public SingleXZInputStream(InputStream inputStream, int i) throws IOException {
        this(inputStream, i, true);
    }

    public SingleXZInputStream(InputStream inputStream, int i, ArrayCache arrayCache) throws IOException {
        this(inputStream, i, true, arrayCache);
    }

    public SingleXZInputStream(InputStream inputStream, int i, boolean bl) throws IOException {
        this(inputStream, i, bl, ArrayCache.getDefaultCache());
    }

    public SingleXZInputStream(InputStream inputStream, int i, boolean bl, ArrayCache arrayCache) throws IOException {
        this(inputStream, i, bl, SingleXZInputStream.readStreamHeader(inputStream), arrayCache);
    }

    SingleXZInputStream(InputStream inputStream, int i, boolean bl, byte[] bs, ArrayCache arrayCache) throws IOException {
        this.arrayCache = arrayCache;
        this.in = inputStream;
        this.memoryLimit = i;
        this.verifyCheck = bl;
        this.streamHeaderFlags = DecoderUtil.decodeStreamHeader(bs);
        this.check = Check.getInstance(this.streamHeaderFlags.checkType);
    }

    public int getCheckType() {
        return this.streamHeaderFlags.checkType;
    }

    public String getCheckName() {
        return this.check.getName();
    }

    @Override
    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] bs, int i, int j) throws IOException {
        int n;
        block12: {
            if (i < 0 || j < 0 || i + j < 0 || i + j > bs.length) {
                throw new IndexOutOfBoundsException();
            }
            if (j == 0) {
                return 0;
            }
            if (this.in == null) {
                throw new XZIOException("Stream closed");
            }
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.endReached) {
                return -1;
            }
            n = 0;
            try {
                while (j > 0) {
                    int n2;
                    if (this.blockDecoder == null) {
                        try {
                            this.blockDecoder = new BlockInputStream(this.in, this.check, this.verifyCheck, this.memoryLimit, -1L, -1L, this.arrayCache);
                        }
                        catch (IndexIndicatorException indexIndicatorException) {
                            this.indexHash.validate(this.in);
                            this.validateStreamFooter();
                            this.endReached = true;
                            return n > 0 ? n : -1;
                        }
                    }
                    if ((n2 = this.blockDecoder.read(bs, i, j)) > 0) {
                        n += n2;
                        i += n2;
                        j -= n2;
                        continue;
                    }
                    if (n2 != -1) continue;
                    this.indexHash.add(this.blockDecoder.getUnpaddedSize(), this.blockDecoder.getUncompressedSize());
                    this.blockDecoder = null;
                }
            }
            catch (IOException iOException) {
                this.exception = iOException;
                if (n != 0) break block12;
                throw iOException;
            }
        }
        return n;
    }

    private void validateStreamFooter() throws IOException {
        byte[] byArray = new byte[12];
        new DataInputStream(this.in).readFully(byArray);
        StreamFlags streamFlags = DecoderUtil.decodeStreamFooter(byArray);
        if (!DecoderUtil.areStreamFlagsEqual(this.streamHeaderFlags, streamFlags) || this.indexHash.getIndexSize() != streamFlags.backwardSize) {
            throw new CorruptedInputException("XZ Stream Footer does not match Stream Header");
        }
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.blockDecoder == null ? 0 : this.blockDecoder.available();
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean bl) throws IOException {
        if (this.in != null) {
            if (this.blockDecoder != null) {
                this.blockDecoder.close();
                this.blockDecoder = null;
            }
            try {
                if (bl) {
                    this.in.close();
                }
            }
            finally {
                this.in = null;
            }
        }
    }
}

