/*
 * Decompiled with CFR 0.152.
 */
package terrablender.mixin;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2169;
import net.minecraft.class_2378;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import terrablender.api.EndBiomeRegistry;
import terrablender.core.TerraBlender;
import terrablender.util.WeightedEntry;
import terrablender.worldgen.IExtendedTheEndBiomeSource;
import terrablender.worldgen.noise.Area;
import terrablender.worldgen.noise.LayeredNoiseUtil;

@Mixin(value={class_2169.class})
public class MixinTheEndBiomeSource
implements IExtendedTheEndBiomeSource {
    @Shadow
    @Final
    private class_6880<class_1959> field_26700;
    @Unique
    private boolean tbInitialized = false;
    @Unique
    private class_2378<class_1959> biomeRegistry;
    @Unique
    private Set<class_6880<class_1959>> tbPossibleBiomes;
    @Unique
    private Area highlandsArea;
    @Unique
    private Area midlandsArea;
    @Unique
    private Area edgeArea;
    @Unique
    private Area islandsArea;

    @Override
    public void initializeForTerraBlender(class_5455 registryAccess, long seed) {
        this.biomeRegistry = registryAccess.method_30530(class_7924.field_41236);
        List<WeightedEntry.Wrapper<class_5321<class_1959>>> highlands = EndBiomeRegistry.getHighlandsBiomes();
        List<WeightedEntry.Wrapper<class_5321<class_1959>>> midlands = EndBiomeRegistry.getMidlandsBiomes();
        List<WeightedEntry.Wrapper<class_5321<class_1959>>> edge = EndBiomeRegistry.getEdgeBiomes();
        List<WeightedEntry.Wrapper<class_5321<class_1959>>> islands = EndBiomeRegistry.getIslandBiomes();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(highlands.stream().map(WeightedEntry.Wrapper::data).toList());
        builder.addAll(midlands.stream().map(WeightedEntry.Wrapper::data).toList());
        builder.addAll(edge.stream().map(WeightedEntry.Wrapper::data).toList());
        builder.addAll(islands.stream().map(WeightedEntry.Wrapper::data).toList());
        builder.add((Object)class_1972.field_9411);
        ImmutableSet allBiomes = builder.build();
        allBiomes.forEach(key -> {
            if (!this.biomeRegistry.method_35842(key)) {
                throw new RuntimeException("Biome " + String.valueOf(key) + " has not been registered!");
            }
        });
        this.tbPossibleBiomes = allBiomes.stream().map(arg_0 -> this.biomeRegistry.method_46747(arg_0)).collect(Collectors.toSet());
        this.highlandsArea = LayeredNoiseUtil.biomeArea(registryAccess, seed, TerraBlender.CONFIG.endHighlandsBiomeSize, highlands);
        this.midlandsArea = LayeredNoiseUtil.biomeArea(registryAccess, seed, TerraBlender.CONFIG.endMidlandsBiomeSize, midlands);
        this.edgeArea = LayeredNoiseUtil.biomeArea(registryAccess, seed, TerraBlender.CONFIG.endEdgeBiomeSize, edge);
        this.islandsArea = LayeredNoiseUtil.biomeArea(registryAccess, seed, TerraBlender.CONFIG.endIslandBiomeSize, islands);
        this.tbInitialized = true;
    }

    @Inject(method={"method_49494()Ljava/util/stream/Stream;"}, at={@At(value="RETURN")}, cancellable=true)
    protected void onCollectPossibleBiomes(CallbackInfoReturnable<Stream<class_6880<class_1959>>> cir) {
        if (!this.tbInitialized) {
            return;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)((Stream)cir.getReturnValue()).collect(Collectors.toSet()));
        builder.addAll(this.tbPossibleBiomes);
        cir.setReturnValue((Object)builder.build().stream());
    }

    @Inject(method={"method_38109(IIILnet/minecraft/class_6544$class_6552;)Lnet/minecraft/class_6880;"}, at={@At(value="HEAD")}, cancellable=true)
    public void onGetNoiseBiome(int x, int y, int z, class_6544.class_6552 sampler, CallbackInfoReturnable<class_6880<class_1959>> cir) {
        int sectionZ;
        if (!this.tbInitialized) {
            return;
        }
        int blockX = class_5742.method_33101((int)x);
        int blockY = class_5742.method_33101((int)y);
        int blockZ = class_5742.method_33101((int)z);
        int sectionX = class_4076.method_18675((int)blockX);
        if ((long)sectionX * (long)sectionX + (long)(sectionZ = class_4076.method_18675((int)blockZ)) * (long)sectionZ <= 4096L) {
            cir.setReturnValue(this.field_26700);
        } else {
            double heightNoise = sampler.comp_367().method_40464((class_6910.class_6912)new class_6910.class_6914(blockX, blockY, blockZ));
            if (heightNoise > 0.25) {
                cir.setReturnValue(this.getBiomeHolder(this.highlandsArea.get(x, z)));
            } else if (heightNoise >= -0.0625) {
                cir.setReturnValue(this.getBiomeHolder(this.midlandsArea.get(x, z)));
            } else {
                cir.setReturnValue(heightNoise < -0.21875 ? this.getBiomeHolder(this.islandsArea.get(x, z)) : this.getBiomeHolder(this.edgeArea.get(x, z)));
            }
        }
    }

    @Unique
    private class_6880<class_1959> getBiomeHolder(int id) {
        return (class_6880)this.biomeRegistry.method_40265(id).orElseThrow();
    }
}

