/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.world.interests.iterator;

import java.util.BitSet;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.caffeinemc.mods.lithium.common.util.Distances;
import net.caffeinemc.mods.lithium.common.world.interests.PointOfInterestSetExtended;
import net.caffeinemc.mods.lithium.common.world.interests.RegionBasedStorageSectionExtended;
import net.minecraft.class_2338;
import net.minecraft.class_4076;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4157;
import net.minecraft.class_4158;
import net.minecraft.class_4180;
import net.minecraft.class_6880;

public class SphereChunkOrderedPoiSetSpliterator
extends Spliterators.AbstractSpliterator<class_4156> {
    private final RegionBasedStorageSectionExtended<class_4157> storage;
    private final int chunkYMin;
    private final int chunkLimit;
    private final int minChunkX;
    private final int maxChunkX;
    private final class_2338 origin;
    private final int radiusSq;
    private final Predicate<class_6880<class_4158>> typeFilter;
    private final class_4153.class_4155 status;
    int chunkX;
    int chunkZ;
    int iteratedChunks;
    BitSet chunkPoiSections;
    int nextPoiSectionIndex;
    Iterator<class_4156> sectionIterator;

    public SphereChunkOrderedPoiSetSpliterator(int radius, class_2338 origin, RegionBasedStorageSectionExtended<class_4157> storage, Predicate<class_6880<class_4158>> typeFilter, class_4153.class_4155 status) {
        super((long)((origin.method_10263() + radius + 1 >> 4) - (origin.method_10263() - radius - 1 >> 4) + 1) * (long)((origin.method_10260() + radius + 1 >> 4) - (origin.method_10260() - radius - 1 >> 4) + 1), 16);
        this.storage = storage;
        this.chunkYMin = this.storage.lithium$getChunkYMin();
        this.origin = origin;
        this.radiusSq = Math.multiplyExact(radius, radius);
        this.typeFilter = typeFilter;
        this.status = status;
        this.minChunkX = origin.method_10263() - radius - 1 >> 4;
        this.maxChunkX = origin.method_10263() + radius + 1 >> 4;
        int minChunkZ = origin.method_10260() - radius - 1 >> 4;
        int maxChunkZ = origin.method_10260() + radius + 1 >> 4;
        this.chunkLimit = (this.maxChunkX - this.minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
        this.chunkX = this.minChunkX - 1;
        this.chunkZ = minChunkZ;
        this.iteratedChunks = -1;
    }

    @Override
    public boolean tryAdvance(Consumer<? super class_4156> action) {
        while (true) {
            if (this.sectionIterator != null && this.sectionIterator.hasNext()) {
                class_4156 next = this.sectionIterator.next();
                if (!this.status.method_19135().test(next) || !Distances.isWithinSphereRadius(this.origin, this.radiusSq, next.method_19141())) continue;
                action.accept((class_4156)next);
                return true;
            }
            if (!this.nextSection()) break;
        }
        return false;
    }

    private boolean nextSection() {
        do {
            int nextSectionIndex;
            if (this.chunkPoiSections == null) continue;
            while ((nextSectionIndex = this.chunkPoiSections.nextSetBit(this.nextPoiSectionIndex)) != -1) {
                this.nextPoiSectionIndex = nextSectionIndex + 1;
                int chunkY = nextSectionIndex + this.chunkYMin;
                if (Distances.getMinSectionDistanceSq(this.origin, this.chunkX, chunkY, this.chunkZ) > (long)this.radiusSq) continue;
                this.sectionIterator = this.getSectionIterator(this.chunkX, chunkY, this.chunkZ);
                if (this.sectionIterator == null || !this.sectionIterator.hasNext()) continue;
                return true;
            }
        } while (this.nextChunk());
        return false;
    }

    private Iterator<class_4156> getSectionIterator(int chunkX, int chunkY, int chunkZ) {
        class_4157 poiSection = ((class_4180)this.storage).method_19294(class_4076.method_18685((int)chunkX, (int)chunkY, (int)chunkZ)).orElse(null);
        if (poiSection == null) {
            return null;
        }
        return ((PointOfInterestSetExtended)poiSection).lithium$iterate(this.typeFilter);
    }

    private boolean nextChunk() {
        do {
            if (this.iteratedChunks >= this.chunkLimit) {
                return false;
            }
            ++this.iteratedChunks;
            ++this.chunkX;
            if (this.chunkX <= this.maxChunkX) continue;
            ++this.chunkZ;
            this.chunkX = this.minChunkX;
        } while (Distances.getMinChunkToBlockDistanceL2Sq(this.origin, this.chunkX, this.chunkZ) > (long)this.radiusSq);
        this.chunkPoiSections = this.storage.lithium$getNonEmptyPOISections(this.chunkX, this.chunkZ);
        this.nextPoiSectionIndex = 0;
        this.sectionIterator = null;
        return true;
    }
}

