/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.ai.poi;

import com.google.common.collect.AbstractIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.caffeinemc.mods.lithium.common.util.Distances;
import net.caffeinemc.mods.lithium.common.world.interests.PointOfInterestSetExtended;
import net.caffeinemc.mods.lithium.common.world.interests.iterator.SinglePointOfInterestTypeFilter;
import net.minecraft.class_2338;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4157;
import net.minecraft.class_4158;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_4157.class})
public abstract class PoiSectionMixin
implements PointOfInterestSetExtended {
    @Mutable
    @Shadow
    @Final
    private Map<class_6880<class_4158>, Set<class_4156>> field_18498;

    @Shadow
    protected abstract Optional<class_4156> method_33584(class_2338 var1);

    @Override
    public void lithium$collectMatchingPoints(Predicate<class_6880<class_4158>> type, class_4153.class_4155 status, Consumer<class_4156> consumer) {
        if (type instanceof SinglePointOfInterestTypeFilter) {
            this.collectWithSingleTypeFilter(((SinglePointOfInterestTypeFilter)type).getType(), status, consumer);
        } else {
            this.collectWithDynamicTypeFilter(type, status, consumer);
        }
    }

    @Override
    public class_4156 lithium$getL2ClosestMatchingPoint(class_2338 center, Predicate<class_6880<class_4158>> typeFilter, Predicate<? super class_4156> poiPredicate) {
        if (typeFilter instanceof SinglePointOfInterestTypeFilter) {
            SinglePointOfInterestTypeFilter singleTypeFilter = (SinglePointOfInterestTypeFilter)typeFilter;
            return this.getL2ClosestMatchingPoint(center, singleTypeFilter.getType(), poiPredicate);
        }
        return this.getL2ClosestMatchingPoint(center, typeFilter, poiPredicate);
    }

    @Unique
    private class_4156 getL2ClosestMatchingPoint(class_2338 center, class_6880<class_4158> type, Predicate<? super class_4156> poiPredicate) {
        Set<class_4156> poiRecords = this.field_18498.get(type);
        if (poiRecords == null || poiRecords.isEmpty()) {
            return null;
        }
        class_4156 closest = null;
        long closestDistanceSq = Long.MAX_VALUE;
        for (class_4156 poiRecord : poiRecords) {
            long distanceSq = Distances.distanceSq(center, poiRecord.method_19141());
            if (distanceSq >= closestDistanceSq || !poiPredicate.test((class_4156)poiRecord)) continue;
            closestDistanceSq = distanceSq;
            closest = poiRecord;
        }
        return closest;
    }

    @Unique
    private class_4156 getL2ClosestMatchingPoint(class_2338 center, Predicate<class_6880<class_4158>> typeFilter, Predicate<? super class_4156> poiPredicate) {
        class_4156 closest = null;
        long closestDistanceSq = Long.MAX_VALUE;
        for (Map.Entry<class_6880<class_4158>, Set<class_4156>> entry : this.field_18498.entrySet()) {
            if (!typeFilter.test(entry.getKey()) || entry.getValue().isEmpty()) continue;
            for (class_4156 poiRecord : entry.getValue()) {
                long distanceSq = Distances.distanceSq(center, poiRecord.method_19141());
                if (distanceSq >= closestDistanceSq || !poiPredicate.test((class_4156)poiRecord)) continue;
                closestDistanceSq = distanceSq;
                closest = poiRecord;
            }
        }
        return closest;
    }

    @Override
    public void lithium$collectMatchingPointsL2Limited(class_2338 center, long maxDistanceSq, Predicate<class_6880<class_4158>> typeFilter, Predicate<? super class_4156> poiPredicate, Consumer<class_4156> consumer, int limit) {
        if (typeFilter instanceof SinglePointOfInterestTypeFilter) {
            SinglePointOfInterestTypeFilter singleTypeFilter = (SinglePointOfInterestTypeFilter)typeFilter;
            this.collectMatchingPointsL2Limited(center, maxDistanceSq, singleTypeFilter.getType(), poiPredicate, consumer, limit);
        } else {
            this.collectMatchingPointsL2Limited(center, maxDistanceSq, typeFilter, poiPredicate, consumer, limit);
        }
    }

    @Unique
    private void collectMatchingPointsL2Limited(class_2338 center, long maxDistanceSq, class_6880<class_4158> type, Predicate<? super class_4156> poiPredicate, Consumer<class_4156> consumer, int limit) {
        Set<class_4156> poiRecords = this.field_18498.get(type);
        if (poiRecords == null || poiRecords.isEmpty()) {
            return;
        }
        for (class_4156 poiRecord : poiRecords) {
            long distanceSq = Distances.distanceSq(center, poiRecord.method_19141());
            if (distanceSq > maxDistanceSq || !poiPredicate.test((class_4156)poiRecord)) continue;
            consumer.accept(poiRecord);
            if (--limit != 0) continue;
            return;
        }
    }

    @Unique
    private void collectMatchingPointsL2Limited(class_2338 center, long maxDistanceSq, Predicate<class_6880<class_4158>> typeFilter, Predicate<? super class_4156> poiPredicate, Consumer<class_4156> consumer, int limit) {
        for (Map.Entry<class_6880<class_4158>, Set<class_4156>> entry : this.field_18498.entrySet()) {
            if (!typeFilter.test(entry.getKey()) || entry.getValue().isEmpty()) continue;
            for (class_4156 poiRecord : entry.getValue()) {
                long distanceSq = Distances.distanceSq(center, poiRecord.method_19141());
                if (distanceSq > maxDistanceSq || !poiPredicate.test((class_4156)poiRecord)) continue;
                consumer.accept(poiRecord);
                if (--limit != 0) continue;
                return;
            }
        }
    }

    @Override
    public class_4156 lithium$getFirstMatchingPoint(class_2338 pos, long maxDistSq, Predicate<class_6880<class_4158>> typeFilter, Predicate<class_2338> posPredicate, class_4153.class_4155 status) {
        if (typeFilter instanceof SinglePointOfInterestTypeFilter) {
            SinglePointOfInterestTypeFilter singleTypeFilter = (SinglePointOfInterestTypeFilter)typeFilter;
            return this.getFirstMatchingPoint(pos, maxDistSq, singleTypeFilter.getType(), posPredicate, status);
        }
        return this.getFirstMatchingPoint(pos, maxDistSq, typeFilter, posPredicate, status);
    }

    @Unique
    private class_4156 getFirstMatchingPoint(class_2338 pos, long maxDistSq, class_6880<class_4158> type, Predicate<class_2338> posPredicate, class_4153.class_4155 status) {
        Set<class_4156> poiRecords = this.field_18498.get(type);
        if (poiRecords == null || poiRecords.isEmpty()) {
            return null;
        }
        Predicate statusPredicate = status.method_19135();
        for (class_4156 poiRecord : poiRecords) {
            long distanceSq = Distances.distanceSq(pos, poiRecord.method_19141());
            if (distanceSq > maxDistSq || !posPredicate.test(poiRecord.method_19141()) || !statusPredicate.test(poiRecord)) continue;
            return poiRecord;
        }
        return null;
    }

    @Unique
    private class_4156 getFirstMatchingPoint(class_2338 pos, long maxDistSq, Predicate<class_6880<class_4158>> typeFilter, Predicate<class_2338> posPredicate, class_4153.class_4155 status) {
        Predicate statusPredicate = status.method_19135();
        for (Map.Entry<class_6880<class_4158>, Set<class_4156>> entry : this.field_18498.entrySet()) {
            if (!typeFilter.test(entry.getKey()) || entry.getValue().isEmpty()) continue;
            for (class_4156 poiRecord : entry.getValue()) {
                long distanceSq = Distances.distanceSq(pos, poiRecord.method_19141());
                if (distanceSq > maxDistSq || !posPredicate.test(poiRecord.method_19141()) || !statusPredicate.test(poiRecord)) continue;
                return poiRecord;
            }
        }
        return null;
    }

    @Unique
    private void collectWithDynamicTypeFilter(Predicate<class_6880<class_4158>> typeFilter, class_4153.class_4155 status, Consumer<class_4156> consumer) {
        for (Map.Entry<class_6880<class_4158>, Set<class_4156>> entry : this.field_18498.entrySet()) {
            if (!typeFilter.test(entry.getKey()) || entry.getValue().isEmpty()) continue;
            for (class_4156 poi : entry.getValue()) {
                if (!status.method_19135().test(poi)) continue;
                consumer.accept(poi);
            }
        }
    }

    @Unique
    private void collectWithSingleTypeFilter(class_6880<class_4158> type, class_4153.class_4155 status, Consumer<class_4156> consumer) {
        Set<class_4156> entries = this.field_18498.get(type);
        if (entries == null || entries.isEmpty()) {
            return;
        }
        for (class_4156 poi : entries) {
            if (!status.method_19135().test(poi)) continue;
            consumer.accept(poi);
        }
    }

    @Override
    public class_4156 lithium$getAt(class_2338 pos) {
        return this.method_33584(pos).orElse(null);
    }

    @Override
    public Iterator<class_4156> lithium$iterate(Predicate<class_6880<class_4158>> typeFilter) {
        if (typeFilter instanceof SinglePointOfInterestTypeFilter) {
            SinglePointOfInterestTypeFilter singleTypeFilter = (SinglePointOfInterestTypeFilter)typeFilter;
            return this.iterateWithSingleTypeFilter(singleTypeFilter.getType());
        }
        return this.iterateWithDynamicTypeFilter(typeFilter);
    }

    @Unique
    private Iterator<class_4156> iterateWithSingleTypeFilter(class_6880<class_4158> type) {
        Set<class_4156> entries = this.field_18498.get(type);
        if (entries == null || entries.isEmpty()) {
            return Collections.emptyIterator();
        }
        return entries.iterator();
    }

    @Unique
    private Iterator<class_4156> iterateWithDynamicTypeFilter(final Predicate<class_6880<class_4158>> typeFilter) {
        final Iterator<Map.Entry<class_6880<class_4158>, Set<class_4156>>> entryIterator = this.field_18498.entrySet().iterator();
        return new AbstractIterator<class_4156>(this){
            private Iterator<class_4156> currentSetIterator = Collections.emptyIterator();

            protected class_4156 computeNext() {
                while (true) {
                    if (this.currentSetIterator.hasNext()) {
                        return this.currentSetIterator.next();
                    }
                    if (!entryIterator.hasNext()) break;
                    Map.Entry entry = (Map.Entry)entryIterator.next();
                    if (!typeFilter.test((class_6880)entry.getKey())) continue;
                    this.currentSetIterator = ((Set)entry.getValue()).iterator();
                }
                return (class_4156)this.endOfData();
            }
        };
    }
}

