/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.data;

import java.util.Arrays;
import java.util.stream.Stream;
import net.caffeinemc.mods.sodium.client.gl.arena.GlBufferArena;
import net.caffeinemc.mods.sodium.client.gl.arena.GlBufferSegment;
import net.caffeinemc.mods.sodium.client.gl.arena.PendingUpload;
import net.caffeinemc.mods.sodium.client.gl.device.CommandList;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.SharedQuadIndexBuffer;
import net.caffeinemc.mods.sodium.client.render.chunk.data.SectionRenderDataUnsafe;
import net.caffeinemc.mods.sodium.client.util.NativeBuffer;
import net.caffeinemc.mods.sodium.client.util.UInt32;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class SectionRenderDataStorage {
    private final @Nullable GlBufferSegment[] vertexAllocations;
    private final @Nullable GlBufferSegment @Nullable [] elementAllocations;
    private @Nullable GlBufferSegment sharedIndexAllocation;
    private int sharedIndexCapacity = 0;
    private boolean needsSharedIndexUpdate = false;
    private final int[] sharedIndexUsage = new int[256];
    private final long pMeshDataArray;

    public SectionRenderDataStorage(boolean storesIndices) {
        this.vertexAllocations = new GlBufferSegment[256];
        this.elementAllocations = storesIndices ? new GlBufferSegment[256] : null;
        this.pMeshDataArray = SectionRenderDataUnsafe.allocateHeap(256);
    }

    public void setVertexData(int localSectionIndex, GlBufferSegment allocation, int[] vertexSegments) {
        GlBufferSegment prev = this.vertexAllocations[localSectionIndex];
        if (prev != null) {
            prev.delete();
        }
        this.vertexAllocations[localSectionIndex] = allocation;
        long pMeshData = this.getDataPointer(localSectionIndex);
        int sliceMask = 0;
        long facingList = 0L;
        for (int i = 0; i < ModelQuadFacing.COUNT; ++i) {
            int segmentIndex = i << 1;
            int facing = vertexSegments[segmentIndex + 1];
            facingList |= (long)facing << i * 8;
            long vertexCount = UInt32.upcast(vertexSegments[segmentIndex]);
            SectionRenderDataUnsafe.setVertexCount(pMeshData, i, vertexCount);
            if (vertexCount <= 0L) continue;
            sliceMask |= 1 << facing;
        }
        SectionRenderDataUnsafe.setBaseVertex(pMeshData, allocation.getOffset());
        SectionRenderDataUnsafe.setSliceMask(pMeshData, sliceMask);
        SectionRenderDataUnsafe.setFacingList(pMeshData, facingList);
    }

    public void setIndexData(int localSectionIndex, GlBufferSegment allocation) {
        if (this.elementAllocations == null) {
            throw new IllegalStateException("Cannot set index data on a render data storage that does not store indices");
        }
        GlBufferSegment prev = this.elementAllocations[localSectionIndex];
        if (prev != null) {
            prev.delete();
        }
        this.elementAllocations[localSectionIndex] = allocation;
        long pMeshData = this.getDataPointer(localSectionIndex);
        SectionRenderDataUnsafe.setLocalBaseElement(pMeshData, allocation.getOffset());
    }

    public boolean setSharedIndexUsage(int localSectionIndex, int newUsage) {
        int previousUsage = this.sharedIndexUsage[localSectionIndex];
        if (previousUsage == newUsage) {
            return false;
        }
        boolean newlyUsingSharedIndexBuffer = false;
        if (newUsage < previousUsage && previousUsage == this.sharedIndexCapacity || newUsage > this.sharedIndexCapacity || newUsage > 0 && this.sharedIndexAllocation == null) {
            this.needsSharedIndexUpdate = true;
        } else {
            long sharedBaseElement = this.sharedIndexAllocation.getOffset();
            long pMeshData = this.getDataPointer(localSectionIndex);
            SectionRenderDataUnsafe.setSharedBaseElement(pMeshData, sharedBaseElement);
            if (previousUsage == 0 && newUsage > 0) {
                newlyUsingSharedIndexBuffer = true;
            }
        }
        this.sharedIndexUsage[localSectionIndex] = newUsage;
        return newlyUsingSharedIndexBuffer;
    }

    public boolean needsSharedIndexUpdate() {
        return this.needsSharedIndexUpdate;
    }

    public boolean updateSharedIndexData(CommandList commandList, GlBufferArena arena, float regionFillFractionInv) {
        this.needsSharedIndexUpdate = false;
        int newCapacity = 0;
        for (int i = 0; i < 256; ++i) {
            newCapacity = Math.max(newCapacity, this.sharedIndexUsage[i]);
        }
        if (newCapacity == this.sharedIndexCapacity) {
            return false;
        }
        this.sharedIndexCapacity = newCapacity;
        if (this.sharedIndexAllocation != null) {
            this.sharedIndexAllocation.delete();
            this.sharedIndexAllocation = null;
        }
        if (this.sharedIndexCapacity == 0) {
            return false;
        }
        if (this.sharedIndexCapacity < 128) {
            this.sharedIndexCapacity += 32;
        }
        NativeBuffer buffer = SharedQuadIndexBuffer.createIndexBuffer(SharedQuadIndexBuffer.IndexType.INTEGER, this.sharedIndexCapacity);
        PendingUpload pendingUpload = new PendingUpload(buffer);
        boolean bufferChanged = arena.upload(commandList, Stream.of(pendingUpload), regionFillFractionInv);
        this.sharedIndexAllocation = pendingUpload.getResult();
        buffer.free();
        if (!bufferChanged) {
            long sharedBaseElement = this.sharedIndexAllocation.getOffset();
            for (int i = 0; i < 256; ++i) {
                if (this.sharedIndexUsage[i] <= 0) continue;
                SectionRenderDataUnsafe.setSharedBaseElement(this.getDataPointer(i), sharedBaseElement);
            }
        }
        return bufferChanged;
    }

    private boolean storesIndexData() {
        return this.elementAllocations != null;
    }

    public void removeIndexData(int localSectionIndex) {
        if (!this.storesIndexData()) {
            throw new IllegalStateException("Cannot remove index data on a render data storage that does not store indices");
        }
        this.removeData(localSectionIndex, false, true);
    }

    public void removeVertexData(int localSectionIndex) {
        this.removeData(localSectionIndex, true, false);
    }

    public void removeData(int localSectionIndex) {
        this.removeData(localSectionIndex, true, true);
    }

    private void removeData(int localSectionIndex, boolean removeVertexData, boolean removeIndexData) {
        GlBufferSegment prev;
        if (removeVertexData && (prev = this.vertexAllocations[localSectionIndex]) != null) {
            prev.delete();
            this.vertexAllocations[localSectionIndex] = null;
        }
        if (removeIndexData && this.storesIndexData()) {
            prev = this.elementAllocations[localSectionIndex];
            if (prev != null) {
                prev.delete();
                this.elementAllocations[localSectionIndex] = null;
            }
            this.setSharedIndexUsage(localSectionIndex, 0);
        }
        long pMeshData = this.getDataPointer(localSectionIndex);
        if ((removeIndexData || !this.storesIndexData()) && removeVertexData) {
            SectionRenderDataUnsafe.clearFull(pMeshData);
        } else if (removeVertexData) {
            SectionRenderDataUnsafe.clearVertexData(pMeshData);
        } else if (removeIndexData) {
            SectionRenderDataUnsafe.clearIndexData(pMeshData);
        }
    }

    public void onBufferResized() {
        for (int sectionIndex = 0; sectionIndex < 256; ++sectionIndex) {
            this.updateMeshes(sectionIndex);
        }
    }

    private void updateMeshes(int sectionIndex) {
        GlBufferSegment allocation = this.vertexAllocations[sectionIndex];
        if (allocation == null) {
            return;
        }
        long data = this.getDataPointer(sectionIndex);
        long offset = allocation.getOffset();
        SectionRenderDataUnsafe.setBaseVertex(data, offset);
    }

    public void onIndexBufferResized() {
        long sharedBaseElement = 0L;
        if (this.sharedIndexAllocation != null) {
            sharedBaseElement = this.sharedIndexAllocation.getOffset();
        }
        for (int i = 0; i < 256; ++i) {
            GlBufferSegment allocation;
            if (this.sharedIndexUsage[i] > 0) {
                SectionRenderDataUnsafe.setSharedBaseElement(this.getDataPointer(i), sharedBaseElement);
                continue;
            }
            if (this.elementAllocations == null || (allocation = this.elementAllocations[i]) == null) continue;
            SectionRenderDataUnsafe.setLocalBaseElement(this.getDataPointer(i), allocation.getOffset());
        }
    }

    public long getDataPointer(int sectionIndex) {
        return SectionRenderDataUnsafe.heapPointer(this.pMeshDataArray, sectionIndex);
    }

    public void delete() {
        SectionRenderDataStorage.deleteAllocations(this.vertexAllocations);
        if (this.elementAllocations != null) {
            SectionRenderDataStorage.deleteAllocations(this.elementAllocations);
        }
        if (this.sharedIndexAllocation != null) {
            this.sharedIndexAllocation.delete();
        }
        SectionRenderDataUnsafe.freeHeap(this.pMeshDataArray);
    }

    private static void deleteAllocations(GlBufferSegment @NonNull [] allocations) {
        for (GlBufferSegment allocation : allocations) {
            if (allocation == null) continue;
            allocation.delete();
        }
        Arrays.fill(allocations, null);
    }
}

