/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.frapi.render;

import net.caffeinemc.mods.sodium.api.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.ColorMixer;
import net.caffeinemc.mods.sodium.client.model.light.LightMode;
import net.caffeinemc.mods.sodium.client.model.light.LightPipelineProvider;
import net.caffeinemc.mods.sodium.client.model.light.data.SingleBlockLightDataCache;
import net.caffeinemc.mods.sodium.client.render.frapi.wrapper.ExtendedMutableQuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.model.AbstractBlockRenderContext;
import net.caffeinemc.mods.sodium.client.render.model.MutableQuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.model.QuadEncoder;
import net.caffeinemc.mods.sodium.client.render.model.SodiumShadeMode;
import net.caffeinemc.mods.sodium.client.render.texture.SpriteFinderCache;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.BlockVertexConsumerProvider;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_324;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4696;
import net.minecraft.class_6575;
import net.minecraft.class_9851;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class NonTerrainBlockRenderContext
extends AbstractBlockRenderContext {
    public static final ThreadLocal<NonTerrainBlockRenderContext> POOL = ThreadLocal.withInitial(NonTerrainBlockRenderContext::new);
    private class_324 colorMap;
    private final SingleBlockLightDataCache lightDataCache = new SingleBlockLightDataCache();
    private BlockVertexConsumerProvider vertexConsumer;
    private Matrix4f matPosition;
    private boolean trustedNormals;
    private Matrix3f matNormal;
    private int overlay;

    public NonTerrainBlockRenderContext() {
        this.lighters = new LightPipelineProvider(this.lightDataCache);
        this.random = new class_6575(42L);
    }

    public void renderModel(class_1920 blockView, class_324 blockColors, class_1087 model, class_2680 state, class_2338 pos, class_4587 poseStack, BlockVertexConsumerProvider buffer, boolean cull, long seed, int overlay) {
        this.level = blockView;
        this.state = state;
        this.pos = pos;
        this.colorMap = blockColors;
        this.vertexConsumer = buffer;
        this.matPosition = poseStack.method_23760().method_23761();
        this.trustedNormals = poseStack.method_23760().field_48930;
        this.matNormal = poseStack.method_23760().method_23762();
        this.overlay = overlay;
        this.defaultRenderType = class_4696.method_23679((class_2680)state);
        this.lightDataCache.reset(pos, blockView);
        this.prepareCulling(cull);
        this.random.method_43052(seed);
        model.emitQuads((QuadEmitter)((ExtendedMutableQuadViewImpl)((Object)this.getForEmitting())).getWrapper(), blockView, pos, state, this.random, this::isFaceCulled);
        this.defaultRenderType = null;
        this.level = null;
        this.lightDataCache.release();
        this.vertexConsumer = null;
    }

    @Override
    protected void processQuad(MutableQuadViewImpl quad) {
        class_9851 aoMode = quad.ambientOcclusion();
        SodiumShadeMode shadeMode = quad.getShadeMode();
        LightMode lightMode = aoMode == class_9851.field_52396 ? this.defaultLightMode : (this.useAmbientOcclusion && aoMode != class_9851.field_52395 ? LightMode.SMOOTH : LightMode.FLAT);
        boolean emissive = quad.emissive();
        class_4588 vertexConsumer = this.getVertexConsumer(quad.getRenderType());
        this.tintQuad(quad);
        this.shadeQuad(quad, lightMode, emissive, shadeMode);
        this.bufferQuad(quad, vertexConsumer);
    }

    private class_4588 getVertexConsumer(class_11515 blendMode) {
        return this.vertexConsumer.getBuffer(blendMode == null ? this.defaultRenderType : blendMode);
    }

    private void tintQuad(MutableQuadViewImpl quad) {
        if (quad.getTintIndex() != -1) {
            int blockColor = 0xFF000000 | this.colorMap.method_1697(this.state, this.level, this.pos, quad.getTintIndex());
            for (int i = 0; i < 4; ++i) {
                quad.setColor(i, ColorMixer.mulComponentWise(blockColor, quad.baseColor(i)));
            }
        }
    }

    @Override
    protected void shadeQuad(MutableQuadViewImpl quad, LightMode lightMode, boolean emissive, SodiumShadeMode shadeMode) {
        super.shadeQuad(quad, lightMode, emissive, shadeMode);
        float[] brightnesses = this.quadLightData.br;
        for (int i = 0; i < 4; ++i) {
            quad.setColor(i, ColorARGB.mulRGB(quad.baseColor(i), brightnesses[i]));
        }
    }

    private void bufferQuad(MutableQuadViewImpl quad, class_4588 vertexConsumer) {
        QuadEncoder.writeQuadVertices(quad, vertexConsumer, this.overlay, this.matPosition, this.trustedNormals, this.matNormal);
        class_1058 sprite = quad.sprite(SpriteFinderCache.forBlockAtlas());
        if (sprite != null) {
            SpriteUtil.INSTANCE.markSpriteActive(sprite);
        }
    }
}

