/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.worldgen.feature.configurations.BOPTreeConfiguration;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2944;
import net.minecraft.class_3481;
import net.minecraft.class_3746;
import net.minecraft.class_4647;
import net.minecraft.class_5819;

public abstract class BOPTreeFeature<FC extends BOPTreeConfiguration>
extends class_2944 {
    protected BOPTreeFeature(Codec<FC> codec) {
        super(codec);
    }

    public boolean placeLeaves(class_1936 level, class_2338 pos, class_4647.class_8179 leaves, FC config) {
        if (this.canReplace(level, pos)) {
            leaves.method_49240(pos, ((BOPTreeConfiguration)((Object)config)).field_29280.method_23455(level.method_8409(), pos));
            return true;
        }
        return false;
    }

    public boolean placeAltLeaves(class_1936 level, class_2338 pos, class_4647.class_8179 leaves, FC config) {
        if (this.canReplace(level, pos)) {
            leaves.method_49240(pos, ((BOPTreeConfiguration)((Object)config)).altFoliageProvider.method_23455(level.method_8409(), pos));
            return true;
        }
        return false;
    }

    public boolean placeLog(class_1936 world, class_2338 pos, BiConsumer<class_2338, class_2680> logs, FC config) {
        return this.placeLog(world, pos, null, logs, config);
    }

    public boolean placeLog(class_1936 level, class_2338 pos, class_2350.class_2351 axis, BiConsumer<class_2338, class_2680> logs, FC config) {
        class_2680 directedLog;
        class_2769 logAxisProperty = this.getLogAxisProperty(level, pos, config);
        class_2680 log = ((BOPTreeConfiguration)((Object)config)).field_21288.method_23455(level.method_8409(), pos);
        class_2680 class_26802 = directedLog = axis != null && logAxisProperty != null ? (class_2680)log.method_11657(logAxisProperty, (Comparable)axis) : log;
        if (this.canReplace(level, pos)) {
            logs.accept(pos, directedLog);
            return true;
        }
        return false;
    }

    public boolean setVine(class_1936 world, class_5819 rand, class_2338 pos, class_2350 side, int length, FC config) {
        class_2680 vine = ((BOPTreeConfiguration)((Object)config)).vineProvider.method_23455(rand, pos);
        class_2680 directedVine = vine.method_26204() instanceof class_2541 ? (class_2680)((class_2680)((class_2680)((class_2680)vine.method_11657((class_2769)class_2541.field_11706, (Comparable)Boolean.valueOf(side == class_2350.field_11043))).method_11657((class_2769)class_2541.field_11702, (Comparable)Boolean.valueOf(side == class_2350.field_11034))).method_11657((class_2769)class_2541.field_11699, (Comparable)Boolean.valueOf(side == class_2350.field_11035))).method_11657((class_2769)class_2541.field_11696, (Comparable)Boolean.valueOf(side == class_2350.field_11039)) : vine;
        boolean setOne = false;
        while (world.method_8320(pos).method_26215() && length > 0 && rand.method_43048(12) > 0) {
            this.method_13153((class_1945)world, pos, directedVine);
            setOne = true;
            --length;
            pos = pos.method_10074();
        }
        return setOne;
    }

    public boolean setHanging(class_1936 level, class_2338 pos, FC config) {
        class_2680 hanging = ((BOPTreeConfiguration)((Object)config)).hangingProvider.method_23455(level.method_8409(), pos);
        if (this.canReplace(level, pos)) {
            this.method_13153((class_1945)level, pos, hanging);
        }
        return false;
    }

    public boolean setTrunkFruit(class_1936 level, class_2338 pos, FC config) {
        class_2680 trunkFruit = ((BOPTreeConfiguration)((Object)config)).trunkFruitProvider.method_23455(level.method_8409(), pos);
        if (trunkFruit == null) {
            return false;
        }
        if (this.canReplace(level, pos)) {
            this.method_13153((class_1945)level, pos, trunkFruit);
        }
        return false;
    }

    protected boolean canReplace(class_1936 level, class_2338 pos) {
        return class_2944.method_16420((class_3746)level, (class_2338)pos) || level.method_16358(pos, state -> {
            class_2248 block = state.method_26204();
            return state.method_26164(class_3481.field_44470) || state.method_26164(class_3481.field_15462) || block == class_2246.field_10597 || block == BOPBlocks.WILLOW_VINE || block == BOPBlocks.DEAD_BRANCH || block == class_2246.field_28680 || block == BOPBlocks.SPANISH_MOSS || block instanceof class_2261;
        });
    }

    protected class_2769 getLogAxisProperty(class_1936 level, class_2338 pos, FC config) {
        class_2680 log = ((BOPTreeConfiguration)((Object)config)).field_21288.method_23455(level.method_8409(), pos);
        for (class_2769 property : log.method_28501()) {
            List allowedValues = property.method_11898();
            if (!allowedValues.contains(class_2350.class_2351.field_11048) || !allowedValues.contains(class_2350.class_2351.field_11052) || !allowedValues.contains(class_2350.class_2351.field_11051)) continue;
            return property;
        }
        return null;
    }

    public static boolean isFree(class_3746 level, class_2338 pos) {
        return BOPTreeFeature.method_27371((class_3746)level, (class_2338)pos) || level.method_16358(pos, state -> state.method_26164(class_3481.field_15475));
    }
}

