/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.parent;

import java.util.ArrayList;
import java.util.List;
import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.client.gui.GuiClientParent;
import team.creative.creativecore.client.gui.GuiControlRect;
import team.creative.creativecore.client.gui.control.parent.GuiClientScrollXY;
import team.creative.creativecore.client.gui.control.parent.GuiClientTable;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.parent.GuiRow;
import team.creative.creativecore.common.gui.control.parent.GuiScrollXY;
import team.creative.creativecore.common.gui.control.parent.GuiTableScrollable;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiClientTableScrollable<T extends GuiTableScrollable>
extends GuiClientParent<T>
implements GuiTableScrollable.GuiTableScrollableDist {
    public GuiClientTableScrollable(T control) {
        super(control);
    }

    @Override
    public GuiScrollXY.GuiScrollXYDist createScrollBox(GuiScrollXY control) {
        var dist = new GuiClientScrollXY<GuiScrollXY>(this, control){

            @Override
            public void flowX(int width, int preferred) {
                this.updateWidth();
            }

            @Override
            public void flowY(int width, int height, int preferred) {
                this.updateHeight();
            }

            @Override
            protected ControlFormatting defaultFormatting() {
                return ControlFormatting.TRANSPARENT;
            }
        };
        dist.scrollbarThickness = 2;
        dist.scrollbarFace = ControlFormatting.ControlStyleFace.CLICKABLE_INACTIVE;
        dist.alternativeScrolling = true;
        return dist;
    }

    @Override
    public GuiParent.GuiParentDistHandler createTopRow(GuiRow control) {
        return new GuiClientParent<GuiParent>((GuiParent)control){

            @Override
            public double getOffsetX() {
                return ((GuiClientParent)((Object)((GuiTableScrollable)GuiClientTableScrollable.this.control).scrollableTable.dist())).getOffsetX();
            }

            @Override
            public boolean mouseScrolled(double x, double y, double delta) {
                return ((GuiClientControl)((Object)((GuiTableScrollable)GuiClientTableScrollable.this.control).scrollableTable.dist())).mouseScrolled(x, y, delta);
            }
        };
    }

    @Override
    public GuiParent.GuiParentDistHandler createFirstCol(GuiParent control) {
        return new GuiClientParent<GuiParent>(control){

            @Override
            public double getOffsetY() {
                return ((GuiClientParent)((Object)((GuiTableScrollable)GuiClientTableScrollable.this.control).scrollableTable.dist())).getOffsetY();
            }

            @Override
            public boolean mouseScrolled(double x, double y, double delta) {
                return ((GuiClientControl)((Object)((GuiTableScrollable)GuiClientTableScrollable.this.control).scrollableTable.dist())).mouseScrolled(x, y, delta);
            }
        };
    }

    protected List<GuiClientTable.GuiTableGroup> createCols() {
        ArrayList<GuiClientTable.GuiTableGroup> cols = new ArrayList<GuiClientTable.GuiTableGroup>();
        int i = 0;
        for (GuiClientControl cell : ((GuiClientParent)((GuiTableScrollable)this.control).topRow.dist()).controls()) {
            if (cols.size() <= i) {
                cols.add(new GuiClientTable.GuiTableGroup());
            }
            ((GuiClientTable.GuiTableGroup)cols.get((int)i)).controls.add(cell);
            ++i;
        }
        GuiClientTable.GuiTableGroup first = (GuiClientTable.GuiTableGroup)cols.get(0);
        for (GuiClientControl control : ((GuiClientParent)((GuiTableScrollable)this.control).firstCol.dist()).controls()) {
            first.controls.add(control);
        }
        for (GuiClientControl control : ((GuiClientParent)((Object)((GuiTableScrollable)this.control).scrollableTable.dist())).controls()) {
            i = 1;
            for (GuiClientControl cell : ((GuiClientParent)control).controls()) {
                if (cols.size() <= i) {
                    cols.add(new GuiClientTable.GuiTableGroup());
                }
                ((GuiClientTable.GuiTableGroup)cols.get((int)i)).controls.add(cell);
                ++i;
            }
        }
        return cols;
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return GuiFlow.STACK_X.preferredWidth(this.createCols(), this.spacing, availableWidth);
    }

    @Override
    public void flowX(int width, int preferred) {
        List<GuiClientTable.GuiTableGroup> cols = this.createCols();
        GuiFlow.STACK_X.flowX(cols, this.spacing, Align.LEFT, width, preferred, this.endlessX());
        GuiControlRect startCol = cols.get(0);
        int startX = startCol.getX();
        GuiControlRect lastCol = cols.get(cols.size() - 1);
        int combinedWidth = Math.min(width, lastCol.getWidth() + lastCol.getX() - startX);
        GuiControlRect bottomChild = ((GuiClientControl)((Object)((GuiTableScrollable)this.control).bottom.dist())).rect;
        bottomChild.setX(0);
        bottomChild.setWidth(combinedWidth + startX, width);
        GuiControlRect firstColChild = ((GuiClientControl)((Object)((GuiTableScrollable)this.control).firstCol.dist())).rect;
        firstColChild.setX(startX);
        firstColChild.setWidth(startCol.getWidth(), width);
        GuiControlRect topRowChild = ((GuiClientControl)((Object)((GuiTableScrollable)this.control).topRow.dist())).rect;
        topRowChild.setX(startX);
        topRowChild.setWidth(combinedWidth, width);
        GuiControlRect scrollableChild = ((GuiClientControl)((Object)((GuiTableScrollable)this.control).scrollableTable.dist())).rect;
        scrollableChild.setX(startX + startCol.getWidth());
        scrollableChild.setWidth(combinedWidth -= startCol.getWidth(), width);
        combinedWidth = lastCol.getWidth() + lastCol.getX() - startX - startCol.getWidth();
        startX += startCol.getWidth();
        for (GuiClientControl guiClientControl : ((GuiTableScrollable)this.control).scrollableTable.dist().controls()) {
            guiClientControl.rect.setX(0);
            guiClientControl.rect.setWidth(combinedWidth, width);
            for (GuiClientControl col : ((GuiClientParent)guiClientControl).controls()) {
                col.rect.setX(col.rect.getX() - startX);
            }
        }
        scrollableChild.flowX();
    }

    protected List<GuiControlRect> createRows() {
        ArrayList<GuiControlRect> rows = new ArrayList<GuiControlRect>();
        rows.add(((GuiClientControl)((Object)((GuiTableScrollable)this.control).topRow.dist())).rect);
        int i = 1;
        for (GuiClientControl row : ((GuiClientParent)((GuiTableScrollable)this.control).firstCol.dist()).controls()) {
            if (rows.size() <= i) {
                rows.add(new GuiClientTable.GuiTableGroup());
            }
            ((GuiClientTable.GuiTableGroup)rows.get((int)i)).controls.add(row);
            ++i;
        }
        i = 1;
        for (GuiClientControl row : ((GuiClientParent)((Object)((GuiTableScrollable)this.control).scrollableTable.dist())).controls()) {
            if (rows.size() <= i) {
                rows.add(new GuiClientTable.GuiTableGroup());
            }
            ((GuiClientTable.GuiTableGroup)rows.get((int)i)).controls.add(row);
            ++i;
        }
        return rows;
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return GuiFlow.STACK_Y.preferredHeight(this.createRows(), this.spacing, width, availableHeight);
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        List<GuiControlRect> rows = this.createRows();
        GuiFlow.STACK_Y.flowY(rows, this.spacing, VAlign.TOP, width, height, preferred, this.endlessY());
        int startY = rows.size() > 1 ? rows.get(1).getY() : rows.get(0).getHeight() + rows.get(0).getY();
        GuiControlRect lastRow = rows.get(rows.size() - 1);
        for (int j = 1; j < rows.size(); ++j) {
            for (GuiClientControl child : ((GuiClientTable.GuiTableGroup)rows.get((int)j)).controls) {
                child.rect.setY(child.rect.getY() - startY);
            }
        }
        int combinedHeight = Math.min(height - startY, lastRow.getHeight() + lastRow.getY() - startY);
        GuiControlRect bottomChild = ((GuiClientControl)((Object)((GuiTableScrollable)this.control).bottom.dist())).rect;
        bottomChild.setY(startY);
        bottomChild.setHeight(combinedHeight, height);
        GuiControlRect firstColChild = ((GuiClientControl)((Object)((GuiTableScrollable)this.control).firstCol.dist())).rect;
        firstColChild.setY(0);
        firstColChild.setHeight(combinedHeight, height);
        GuiControlRect scrollableChild = ((GuiClientControl)((Object)((GuiTableScrollable)this.control).scrollableTable.dist())).rect;
        scrollableChild.setY(0);
        scrollableChild.setHeight(combinedHeight, height);
        scrollableChild.flowY();
    }

    @Override
    protected boolean endlessX() {
        return true;
    }

    @Override
    protected boolean endlessY() {
        return true;
    }
}

