/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network.type;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8038;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9141;
import net.minecraft.class_9142;
import net.minecraft.class_9326;
import org.joml.Vector3d;
import org.joml.Vector3f;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.network.BundlePacketWrapper;
import team.creative.creativecore.common.network.CreativeByteBuf;
import team.creative.creativecore.common.network.CreativeNetworkUtils;
import team.creative.creativecore.common.network.type.NetworkFieldType;
import team.creative.creativecore.common.network.type.NetworkFieldTypeClass;
import team.creative.creativecore.common.network.type.NetworkFieldTypeSpecial;
import team.creative.creativecore.common.util.filter.BiFilter;
import team.creative.creativecore.common.util.filter.Filter;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3c;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.creativecore.common.util.math.vec.Vec1f;
import team.creative.creativecore.common.util.math.vec.Vec2d;
import team.creative.creativecore.common.util.math.vec.Vec2f;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.creativecore.common.util.mc.ConnectionUtils;
import team.creative.creativecore.common.util.registry.exception.RegistryException;
import team.creative.creativecore.common.util.type.Bunch;
import team.creative.creativecore.common.util.type.itr.IterableIterator;
import team.creative.creativecore.common.util.type.itr.SingleIterator;

public class NetworkFieldTypes {
    private static final Gson GSON = new Gson();
    private static final List<NetworkFieldTypeSpecial> SPECIAL_PARSERS = new ArrayList<NetworkFieldTypeSpecial>();
    private static final HashMap<Class, NetworkFieldType> PARSERS = new HashMap();

    public static <T> void register(NetworkFieldType<T> parser, Class<T> classType) {
        PARSERS.put(classType, parser);
    }

    public static <T> class_9139<class_9129, T> registerAndCodec(NetworkFieldTypeClass<T> parser, Class<T> classType) {
        NetworkFieldTypes.register(parser, classType);
        return class_9139.method_56437((x, y) -> parser.writeContent((Object)y, (class_9129)x), parser::readContent);
    }

    public static <T> void register(NetworkFieldType<T> parser, Class<? extends T> ... classType) {
        for (Class<? extends T> clazz : classType) {
            PARSERS.put(clazz, parser);
        }
    }

    public static <T> void register(NetworkFieldTypeSpecial parser) {
        SPECIAL_PARSERS.add(parser);
    }

    public static NetworkFieldType get(Field field) {
        return NetworkFieldTypes.get(field.getType(), field.getGenericType());
    }

    public static <T> NetworkFieldType<T> get(Class<T> classType) {
        try {
            NetworkFieldType parser = PARSERS.get(classType);
            if (parser != null) {
                return parser;
            }
        }
        catch (Exception e1) {
            CreativeCore.LOGGER.error((Object)e1);
        }
        throw new RuntimeException("No field type found for " + classType.getSimpleName());
    }

    public static NetworkFieldType get(Class classType, Type genericType) {
        try {
            NetworkFieldType parser = PARSERS.get(classType);
            if (parser != null) {
                return parser;
            }
            for (int i = 0; i < SPECIAL_PARSERS.size(); ++i) {
                if (!NetworkFieldTypes.SPECIAL_PARSERS.get((int)i).predicate.test(classType, genericType)) continue;
                return SPECIAL_PARSERS.get(i);
            }
        }
        catch (Exception e1) {
            CreativeCore.LOGGER.error((Object)e1);
        }
        throw new RuntimeException("No field type found for " + classType.getSimpleName());
    }

    public static <T> void write(Class<T> clazz, T object, CreativeByteBuf buffer, class_2598 flow) {
        NetworkFieldTypes.get(clazz).write(object, clazz, null, buffer, flow);
    }

    public static <T> void writeMany(Class<T> clazz, Bunch<T> bunch, CreativeByteBuf buffer, class_2598 flow) {
        buffer.method_53002(bunch.size());
        NetworkFieldType type = NetworkFieldTypes.get(clazz);
        for (Object t : bunch) {
            type.write(t, clazz, null, buffer, flow);
        }
    }

    public static <T> void writeMany(Class<T> clazz, Collection<T> collection, CreativeByteBuf buffer, class_2598 flow) {
        buffer.method_53002(collection.size());
        NetworkFieldType<T> type = NetworkFieldTypes.get(clazz);
        for (T t : collection) {
            type.write(t, clazz, null, buffer, flow);
        }
    }

    public static <T> void writeMany(Class<T> clazz, T[] collection, CreativeByteBuf buffer, class_2598 flow) {
        buffer.method_53002(collection.length);
        NetworkFieldType<T> type = NetworkFieldTypes.get(clazz);
        for (T t : collection) {
            type.write(t, clazz, null, buffer, flow);
        }
    }

    public static <T> T read(Class<T> clazz, CreativeByteBuf buffer, class_2598 flow) {
        return NetworkFieldTypes.get(clazz).read(clazz, null, buffer, flow);
    }

    public static <T> Iterable<T> readMany(final Class<T> clazz, final CreativeByteBuf buffer, final class_2598 flow) {
        final int length = buffer.readInt();
        final NetworkFieldType<T> type = NetworkFieldTypes.get(clazz);
        return new IterableIterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < length;
            }

            @Override
            public T next() {
                ++this.index;
                return type.read(clazz, null, buffer, flow);
            }
        };
    }

    public static void writeIntArray(int[] array, class_9129 buffer) {
        buffer.method_53002(array.length);
        for (int i = 0; i < array.length; ++i) {
            buffer.method_53002(array[i]);
        }
    }

    public static int[] readIntArray(class_9129 buffer) {
        int[] array = new int[buffer.readInt()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = buffer.readInt();
        }
        return array;
    }

    static {
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Boolean>(){

            @Override
            protected void writeContent(Boolean content, class_9129 buffer) {
                buffer.method_52964(content.booleanValue());
            }

            @Override
            protected Boolean readContent(class_9129 buffer) {
                return buffer.readBoolean();
            }
        }, Boolean.TYPE, Boolean.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Byte>(){

            @Override
            protected void writeContent(Byte content, class_9129 buffer) {
                buffer.method_52997((int)content.byteValue());
            }

            @Override
            protected Byte readContent(class_9129 buffer) {
                return buffer.readByte();
            }
        }, Byte.TYPE, Byte.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Short>(){

            @Override
            protected void writeContent(Short content, class_9129 buffer) {
                buffer.method_52998((int)content.shortValue());
            }

            @Override
            protected Short readContent(class_9129 buffer) {
                return buffer.readShort();
            }
        }, Short.TYPE, Short.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Integer>(){

            @Override
            protected void writeContent(Integer content, class_9129 buffer) {
                buffer.method_53002(content.intValue());
            }

            @Override
            protected Integer readContent(class_9129 buffer) {
                return buffer.readInt();
            }
        }, Integer.TYPE, Integer.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Long>(){

            @Override
            protected void writeContent(Long content, class_9129 buffer) {
                buffer.method_52974(content.longValue());
            }

            @Override
            protected Long readContent(class_9129 buffer) {
                return buffer.readLong();
            }
        }, Long.TYPE, Long.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Float>(){

            @Override
            protected void writeContent(Float content, class_9129 buffer) {
                buffer.method_52941(content.floatValue());
            }

            @Override
            protected Float readContent(class_9129 buffer) {
                return Float.valueOf(buffer.readFloat());
            }
        }, Float.TYPE, Float.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Double>(){

            @Override
            protected void writeContent(Double content, class_9129 buffer) {
                buffer.method_52940(content.doubleValue());
            }

            @Override
            protected Double readContent(class_9129 buffer) {
                return buffer.readDouble();
            }
        }, Double.TYPE, Double.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_2338>(){

            @Override
            protected void writeContent(class_2338 content, class_9129 buffer) {
                buffer.method_10807(content);
            }

            @Override
            protected class_2338 readContent(class_9129 buffer) {
                return buffer.method_10811();
            }
        }, class_2338.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<String>(){

            @Override
            protected void writeContent(String content, class_9129 buffer) {
                buffer.method_10814(content);
            }

            @Override
            protected String readContent(class_9129 buffer) {
                return buffer.method_10800(Short.MAX_VALUE);
            }
        }, String.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_2561>(){

            @Override
            protected void writeContent(class_2561 content, class_9129 buffer) {
                class_2540.method_56892((ByteBuf)buffer, (Object)content, (class_9142)class_8824.field_48540);
            }

            @Override
            protected class_2561 readContent(class_9129 buffer) {
                return (class_2561)class_2540.method_56893((ByteBuf)buffer, (class_9141)class_8824.field_48540);
            }
        }, class_2561.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_2487>(){

            @Override
            protected void writeContent(class_2487 content, class_9129 buffer) {
                buffer.method_10794((class_2520)content);
            }

            @Override
            protected class_2487 readContent(class_9129 buffer) {
                return buffer.method_10798();
            }
        }, class_2487.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_1799>(){

            @Override
            protected void writeContent(class_1799 content, class_9129 buffer) {
                class_2540.method_56892((ByteBuf)buffer, (Object)content, (class_9142)class_1799.field_49268);
            }

            @Override
            protected class_1799 readContent(class_9129 buffer) {
                return (class_1799)class_2540.method_56893((ByteBuf)buffer, (class_9141)class_1799.field_49268);
            }
        }, class_1799.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_2960>(){

            @Override
            protected void writeContent(class_2960 content, class_9129 buffer) {
                buffer.method_10812(content);
            }

            @Override
            protected class_2960 readContent(class_9129 buffer) {
                return buffer.method_10810();
            }
        }, class_2960.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_2680>(){

            @Override
            protected void writeContent(class_2680 content, class_9129 buffer) {
                buffer.method_53002(class_2248.method_9507((class_2680)content));
            }

            @Override
            protected class_2680 readContent(class_9129 buffer) {
                return class_2248.method_9531((int)buffer.readInt());
            }
        }, class_2680.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_2248>(){

            @Override
            protected void writeContent(class_2248 content, class_9129 buffer) {
                buffer.method_10812(class_7923.field_41175.method_10221((Object)content));
            }

            @Override
            protected class_2248 readContent(class_9129 buffer) {
                return (class_2248)class_7923.field_41175.method_63535(buffer.method_10810());
            }
        }, class_2248.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_1792>(){

            @Override
            protected void writeContent(class_1792 content, class_9129 buffer) {
                buffer.method_10812(class_7923.field_41178.method_10221((Object)content));
            }

            @Override
            protected class_1792 readContent(class_9129 buffer) {
                return (class_1792)class_7923.field_41178.method_63535(buffer.method_10810());
            }
        }, class_1792.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vector3d>(){

            @Override
            protected void writeContent(Vector3d content, class_9129 buffer) {
                buffer.method_52940(content.x);
                buffer.method_52940(content.y);
                buffer.method_52940(content.z);
            }

            @Override
            protected Vector3d readContent(class_9129 buffer) {
                return new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            }
        }, Vector3d.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_243>(){

            @Override
            protected void writeContent(class_243 content, class_9129 buffer) {
                buffer.method_52940(content.field_1352);
                buffer.method_52940(content.field_1351);
                buffer.method_52940(content.field_1350);
            }

            @Override
            protected class_243 readContent(class_9129 buffer) {
                return new class_243(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            }
        }, class_243.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec1d>(){

            @Override
            protected void writeContent(Vec1d content, class_9129 buffer) {
                buffer.method_52940(content.x);
            }

            @Override
            protected Vec1d readContent(class_9129 buffer) {
                return new Vec1d(buffer.readDouble());
            }
        }, Vec1d.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec1f>(){

            @Override
            protected void writeContent(Vec1f content, class_9129 buffer) {
                buffer.method_52941(content.x);
            }

            @Override
            protected Vec1f readContent(class_9129 buffer) {
                return new Vec1f(buffer.readFloat());
            }
        }, Vec1f.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec2d>(){

            @Override
            protected void writeContent(Vec2d content, class_9129 buffer) {
                buffer.method_52940(content.x);
                buffer.method_52940(content.y);
            }

            @Override
            protected Vec2d readContent(class_9129 buffer) {
                return new Vec2d(buffer.readDouble(), buffer.readDouble());
            }
        }, Vec2d.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec2f>(){

            @Override
            protected void writeContent(Vec2f content, class_9129 buffer) {
                buffer.method_52941(content.x);
                buffer.method_52941(content.y);
            }

            @Override
            protected Vec2f readContent(class_9129 buffer) {
                return new Vec2f(buffer.readFloat(), buffer.readFloat());
            }
        }, Vec2f.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec3d>(){

            @Override
            protected void writeContent(Vec3d content, class_9129 buffer) {
                buffer.method_52940(content.x);
                buffer.method_52940(content.y);
                buffer.method_52940(content.z);
            }

            @Override
            protected Vec3d readContent(class_9129 buffer) {
                return new Vec3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            }
        }, Vec3d.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec3f>(){

            @Override
            protected void writeContent(Vec3f content, class_9129 buffer) {
                buffer.method_52941(content.x);
                buffer.method_52941(content.y);
                buffer.method_52941(content.z);
            }

            @Override
            protected Vec3f readContent(class_9129 buffer) {
                return new Vec3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        }, Vec3f.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vector3f>(){

            @Override
            protected void writeContent(Vector3f content, class_9129 buffer) {
                buffer.method_52941(content.x());
                buffer.method_52941(content.y());
                buffer.method_52941(content.z());
            }

            @Override
            protected Vector3f readContent(class_9129 buffer) {
                return new Vector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        }, Vector3f.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<UUID>(){

            @Override
            protected void writeContent(UUID content, class_9129 buffer) {
                buffer.method_10814(content.toString());
            }

            @Override
            protected UUID readContent(class_9129 buffer) {
                return UUID.fromString(buffer.method_10800(Short.MAX_VALUE));
            }
        }, UUID.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<JsonObject>(){

            @Override
            protected void writeContent(JsonObject content, class_9129 buffer) {
                buffer.method_10814(content.toString());
            }

            @Override
            protected JsonObject readContent(class_9129 buffer) {
                return (JsonObject)GSON.fromJson(buffer.method_10800(Short.MAX_VALUE), JsonObject.class);
            }
        }, JsonObject.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_6880>(){

            @Override
            protected void writeContent(class_6880 content, class_9129 buffer) {
                class_5321 key = (class_5321)content.method_40230().get();
                buffer.method_10812(key.method_41185());
                buffer.method_10812(key.method_29177());
            }

            @Override
            protected class_6880 readContent(class_9129 buffer) {
                class_5321 key = class_5321.method_29179((class_5321)buffer.method_53006(), (class_2960)buffer.method_10810());
                class_2378 l = buffer.method_56349().method_30530(key.method_58273());
                return l.method_46747(key);
            }
        }, class_6880.class);
        NetworkFieldTypes.register(new NetworkFieldTypeSpecial<Object>((x, y) -> x.isArray()){

            @Override
            public void write(Object content, Class classType, Type genericType, CreativeByteBuf buffer, class_2598 flow) {
                Class<?> subClass = classType.getComponentType();
                NetworkFieldType subParser = NetworkFieldTypes.get(subClass, null);
                int length = Array.getLength(content);
                buffer.method_53002(length);
                for (int i = 0; i < length; ++i) {
                    subParser.write(Array.get(content, i), subClass, null, buffer, flow);
                }
            }

            @Override
            public Object read(Class classType, Type genericType, CreativeByteBuf buffer, class_2598 flow) {
                int length = buffer.readInt();
                Class<?> subClass = classType.getComponentType();
                NetworkFieldType subParser = NetworkFieldTypes.get(subClass, null);
                Object object = Array.newInstance(subClass, length);
                for (int i = 0; i < length; ++i) {
                    Array.set(object, i, subParser.read(subClass, null, buffer, flow));
                }
                return object;
            }
        });
        NetworkFieldTypes.register(new NetworkFieldTypeSpecial((x, y) -> x.equals(ArrayList.class) || x.equals(List.class)){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void write(Object content, Class classType, Type genericType, CreativeByteBuf buffer, class_2598 flow) {
                Type subType;
                Class subClass;
                if (!(genericType instanceof ParameterizedType)) throw new RuntimeException("Missing generic type");
                ParameterizedType p = (ParameterizedType)genericType;
                Type[] types = p.getActualTypeArguments();
                if (types.length != 1) throw new RuntimeException("Invalid generic type");
                Type type = p.getActualTypeArguments()[0];
                if (type instanceof ParameterizedType) {
                    ParameterizedType p2 = (ParameterizedType)type;
                    subClass = (Class)p2.getRawType();
                    subType = types[0];
                } else {
                    subClass = (Class)p.getActualTypeArguments()[0];
                    subType = types[0];
                }
                NetworkFieldType subParser = NetworkFieldTypes.get(subClass, subType);
                if (subParser == null) {
                    throw new RuntimeException("Invalid class type " + classType.getComponentType().getName());
                }
                int length = ((List)content).size();
                buffer.method_53002(length);
                for (int i = 0; i < length; ++i) {
                    subParser.write(((List)content).get(i), subClass, subType, buffer, flow);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object read(Class classType, Type genericType, CreativeByteBuf buffer, class_2598 flow) {
                Type subType;
                Class subClass;
                if (!(genericType instanceof ParameterizedType)) throw new RuntimeException("Missing generic type");
                ParameterizedType p = (ParameterizedType)genericType;
                Type[] types = p.getActualTypeArguments();
                if (types.length != 1) throw new RuntimeException("Invalid generic type");
                Type type = p.getActualTypeArguments()[0];
                if (type instanceof ParameterizedType) {
                    ParameterizedType p2 = (ParameterizedType)type;
                    subClass = (Class)p2.getRawType();
                    subType = types[0];
                } else {
                    subClass = (Class)p.getActualTypeArguments()[0];
                    subType = types[0];
                }
                NetworkFieldType subParser = NetworkFieldTypes.get(subClass, subType);
                if (subParser == null) {
                    throw new RuntimeException("Invalid class type " + classType.getComponentType().getName());
                }
                int length = buffer.readInt();
                ArrayList list = new ArrayList(length);
                for (int j = 0; j < length; ++j) {
                    list.add(subParser.read(subClass, subType, buffer, flow));
                }
                return list;
            }
        });
        NetworkFieldTypes.register(new NetworkFieldTypeSpecial<Object>((x, y) -> x.isEnum()){

            @Override
            public void write(Object content, Class classType, Type genericType, CreativeByteBuf buffer, class_2598 flow) {
                buffer.method_10817((Enum)content);
            }

            @Override
            public Object read(Class classType, Type genericType, CreativeByteBuf buffer, class_2598 flow) {
                return buffer.method_10818(classType);
            }
        });
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Filter>(){

            @Override
            protected void writeContent(Filter content, class_9129 buffer) {
                try {
                    buffer.method_10794((class_2520)Filter.SERIALIZER.write(content));
                }
                catch (RegistryException e) {
                    CreativeCore.LOGGER.error((Object)e);
                }
            }

            @Override
            protected Filter readContent(class_9129 buffer) {
                try {
                    return Filter.SERIALIZER.read((class_2487)buffer.method_30616(class_2505.method_53898()));
                }
                catch (RegistryException e) {
                    CreativeCore.LOGGER.error((Object)e);
                    return Filter.or(new Filter[0]);
                }
            }
        }, Filter.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<BiFilter>(){

            @Override
            protected void writeContent(BiFilter content, class_9129 buffer) {
                try {
                    buffer.method_10794((class_2520)BiFilter.SERIALIZER.write(content));
                }
                catch (RegistryException e) {
                    CreativeCore.LOGGER.error((Object)e);
                }
            }

            @Override
            protected BiFilter readContent(class_9129 buffer) {
                try {
                    return BiFilter.SERIALIZER.read((class_2487)buffer.method_30616(class_2505.method_53898()));
                }
                catch (RegistryException e) {
                    CreativeCore.LOGGER.error((Object)e);
                    return BiFilter.or(new BiFilter[0]);
                }
            }
        }, BiFilter.class);
        NetworkFieldTypes.register(new NetworkFieldTypeSpecial<class_2520>((x, y) -> class_2520.class.isAssignableFrom((Class<?>)x)){

            @Override
            public void write(class_2520 content, Class classType, Type genericType, CreativeByteBuf buffer, class_2598 flow) {
                buffer.method_10794(content);
            }

            @Override
            public class_2520 read(Class classType, Type genericType, CreativeByteBuf buffer, class_2598 flow) {
                return buffer.method_30616(class_2505.method_53898());
            }
        });
        NetworkFieldTypes.register(new NetworkFieldTypeSpecial<class_2596>((x, y) -> class_2596.class.isAssignableFrom((Class<?>)x)){

            @Override
            public void write(class_2596 content, Class classType, Type genericType, CreativeByteBuf buffer, class_2598 flow) {
                class_9139 codec = ConnectionUtils.getProtocolInfo(buffer.connection).comp_2236();
                boolean bundle = content instanceof class_8038;
                if (bundle) {
                    List packets = CreativeNetworkUtils.flatten(new SingleIterator(content));
                    buffer.method_53002(packets.size());
                    for (class_2596 class_25962 : packets) {
                        buffer.method_43826(class_25962, (class_9142)codec);
                    }
                } else {
                    buffer.method_53002(0);
                    buffer.method_43826(content, (class_9142)codec);
                }
            }

            @Override
            public class_2596 read(Class classType, Type genericType, CreativeByteBuf buffer, class_2598 flow) {
                class_9139 codec = ConnectionUtils.getProtocolInfo(buffer.connection).comp_2236();
                int size = buffer.readInt();
                if (size == 0) {
                    return (class_2596)buffer.method_43827((class_9141)codec);
                }
                ArrayList packets = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    packets.add((class_2596)buffer.method_43827((class_9141)codec));
                }
                return new BundlePacketWrapper(packets);
            }
        });
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Class>(){

            @Override
            protected void writeContent(Class content, class_9129 buffer) {
                buffer.method_10814(content.getName());
            }

            @Override
            protected Class readContent(class_9129 buffer) {
                try {
                    return Class.forName(buffer.method_10800(Short.MAX_VALUE));
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
        }, Class.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<IntMatrix3c>(){

            @Override
            protected void writeContent(IntMatrix3c content, class_9129 buffer) {
                buffer.method_53002(content.m00());
                buffer.method_53002(content.m01());
                buffer.method_53002(content.m02());
                buffer.method_53002(content.m10());
                buffer.method_53002(content.m11());
                buffer.method_53002(content.m12());
                buffer.method_53002(content.m20());
                buffer.method_53002(content.m21());
                buffer.method_53002(content.m22());
            }

            @Override
            protected IntMatrix3c readContent(class_9129 buffer) {
                return new IntMatrix3(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
            }
        }, IntMatrix3c.class, IntMatrix3.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_9326>(){

            @Override
            protected void writeContent(class_9326 content, class_9129 buffer) {
                class_9326.field_49590.encode((Object)buffer, (Object)content);
            }

            @Override
            protected class_9326 readContent(class_9129 buffer) {
                return (class_9326)class_9326.field_49590.decode((Object)buffer);
            }
        }, class_9326.class);
    }
}

