/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block.entity;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntImmutableList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1275;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1732;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_8824;
import net.minecraft.class_8942;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import vectorwing.farmersdelight.common.block.CookingPotBlock;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.block.entity.container.CookingPotMenu;
import vectorwing.farmersdelight.common.block.entity.inventory.CookingPotItemHandler;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.common.item.component.ItemStackWrapper;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.registry.ModDataComponents;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;
import vectorwing.farmersdelight.refabricated.inventory.ItemStackHandler;
import vectorwing.farmersdelight.refabricated.inventory.RecipeWrapper;

public class CookingPotBlockEntity
extends SyncedBlockEntity
implements ExtendedScreenHandlerFactory<class_2338>,
HeatableBlockEntity,
class_1275,
class_1732 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<Map<class_5321<class_1860<?>>, Integer>> RECIPES_USED_CODEC = Codec.unboundedMap((Codec)class_1860.field_56667, (Codec)Codec.INT);
    public static final int MEAL_DISPLAY_SLOT = 6;
    public static final int CONTAINER_SLOT = 7;
    public static final int OUTPUT_SLOT = 8;
    public static final int INVENTORY_SIZE = 9;
    public static final Map<class_1792, class_1792> INGREDIENT_REMAINDER_OVERRIDES = Map.ofEntries(Map.entry(class_1802.field_27876, class_1802.field_8550), Map.entry(class_1802.field_28354, class_1802.field_8550), Map.entry(class_1802.field_8666, class_1802.field_8550), Map.entry(class_1802.field_8108, class_1802.field_8550), Map.entry(class_1802.field_8714, class_1802.field_8550), Map.entry(class_1802.field_8478, class_1802.field_8550), Map.entry(class_1802.field_8766, class_1802.field_8428), Map.entry(class_1802.field_8208, class_1802.field_8428), Map.entry(class_1802.field_8308, class_1802.field_8428), Map.entry(class_1802.field_8515, class_1802.field_8428), Map.entry(class_1802.field_8574, class_1802.field_8469), Map.entry(class_1802.field_8436, class_1802.field_8469), Map.entry(class_1802.field_8150, class_1802.field_8469), Map.entry(class_1802.field_8287, class_1802.field_8469));
    private final ItemStackHandler inventory = this.createHandler();
    private final CookingPotItemHandler inputHandler = new CookingPotItemHandler(this.inventory, class_2350.field_11036);
    private final CookingPotItemHandler outputHandler = new CookingPotItemHandler(this.inventory, class_2350.field_11033);
    private int cookTime;
    private int cookTimeTotal;
    private class_1799 mealContainerStack = class_1799.field_8037;
    private class_2561 customName;
    protected final class_3913 cookingPotData = this.createIntArray();
    private final Object2IntOpenHashMap<class_5321<class_1860<?>>> usedRecipeTracker = new Object2IntOpenHashMap();
    private final class_1863.class_7266<RecipeWrapper, CookingPotRecipe> quickCheck = class_1863.method_42302(ModRecipeTypes.COOKING.get());

    public CookingPotBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.COOKING_POT.get(), pos, state);
    }

    public static void init() {
        ItemStorage.SIDED.registerForBlockEntity(CookingPotBlockEntity::getStorage, ModBlockEntityTypes.COOKING_POT.get());
    }

    public static class_1799 getMealFromItem(class_1799 cookingPotStack) {
        if (!cookingPotStack.method_31574(ModItems.COOKING_POT.get())) {
            return class_1799.field_8037;
        }
        return ((ItemStackWrapper)cookingPotStack.method_58695(ModDataComponents.MEAL.get(), (Object)ItemStackWrapper.EMPTY)).getStack();
    }

    public static void takeServingFromItem(class_1799 cookingPotStack) {
        if (!cookingPotStack.method_31574(ModItems.COOKING_POT.get())) {
            return;
        }
        class_1799 mealStack = ((ItemStackWrapper)cookingPotStack.method_58695(ModDataComponents.MEAL.get(), (Object)ItemStackWrapper.EMPTY)).getStack();
        mealStack.method_7934(1);
        cookingPotStack.method_57379(ModDataComponents.MEAL.get(), (Object)new ItemStackWrapper(mealStack));
    }

    public static class_1799 getContainerFromItem(class_1799 cookingPotStack) {
        if (!cookingPotStack.method_31574(ModItems.COOKING_POT.get())) {
            return class_1799.field_8037;
        }
        return ((ItemStackWrapper)cookingPotStack.method_58695(ModDataComponents.CONTAINER.get(), (Object)ItemStackWrapper.EMPTY)).getStack();
    }

    public void method_11014(class_11368 input) {
        super.method_11014(input);
        this.inventory.deserialize(input.method_71434("Inventory"));
        this.cookTime = input.method_71424("CookTime", 0);
        this.cookTimeTotal = input.method_71424("CookTimeTotal", 0);
        this.mealContainerStack = input.method_71426("Container", class_1799.field_49266).orElse(class_1799.field_8037);
        this.customName = input.method_71426("CustomName", class_8824.field_46597).orElse(null);
        this.usedRecipeTracker.clear();
        this.usedRecipeTracker.putAll(input.method_71426("RecipesUsed", RECIPES_USED_CODEC).orElse(Collections.emptyMap()));
    }

    public void method_11007(class_11372 output) {
        super.method_11007(output);
        output.method_71465("CookTime", this.cookTime);
        output.method_71465("CookTimeTotal", this.cookTimeTotal);
        output.method_71477("Container", class_1799.field_24671, (Object)(this.mealContainerStack.method_7960() ? null : this.mealContainerStack));
        if (this.customName != null) {
            output.method_71477("CustomName", class_8824.field_46597, (Object)this.customName);
        }
        this.inventory.serialize(output.method_71461("Inventory"));
        output.method_71468("RecipesUsed", RECIPES_USED_CODEC, this.usedRecipeTracker);
    }

    private void writeItems(class_11372 output) {
        super.method_11007(output);
        output.method_71477("Container", class_1799.field_24671, (Object)(this.mealContainerStack.method_7960() ? null : this.mealContainerStack));
        this.inventory.serialize(output.method_71461("Inventory"));
    }

    public void writeMeal(class_11372 output) {
        if (this.getMeal().method_7960()) {
            return;
        }
        ItemStackHandler drops = new ItemStackHandler(9);
        for (int i = 0; i < 9; ++i) {
            drops.setStackInSlot(i, i == 6 ? this.inventory.getStackInSlot(i) : class_1799.field_8037);
        }
        if (this.customName != null) {
            output.method_71477("CustomName", class_8824.field_46597, (Object)this.customName);
        }
        output.method_71477("Container", class_1799.field_49266, (Object)(this.mealContainerStack.method_7960() ? null : this.mealContainerStack));
        drops.serialize(output.method_71461("Inventory"));
    }

    public class_1799 getAsItem() {
        class_1799 stack = new class_1799((class_1935)ModItems.COOKING_POT.get());
        stack.method_57365(this.method_57590());
        return stack;
    }

    public static void cookingTick(class_3218 level, class_2338 pos, class_2680 state, CookingPotBlockEntity cookingPot) {
        boolean isHeated = cookingPot.isHeated((class_1937)level, pos);
        boolean didInventoryChange = false;
        if (isHeated && cookingPot.hasInput()) {
            Optional<class_8786<CookingPotRecipe>> recipe = cookingPot.getMatchingRecipe(new RecipeWrapper(cookingPot.inventory), level);
            if (recipe.isPresent() && cookingPot.canCook((CookingPotRecipe)recipe.get().comp_1933())) {
                didInventoryChange = cookingPot.processCooking(recipe.get(), cookingPot);
            } else {
                cookingPot.cookTime = class_3532.method_15340((int)(cookingPot.cookTime - 2), (int)0, (int)cookingPot.cookTimeTotal);
            }
        } else if (cookingPot.cookTime > 0) {
            cookingPot.cookTime = class_3532.method_15340((int)(cookingPot.cookTime - 2), (int)0, (int)cookingPot.cookTimeTotal);
        }
        class_1799 mealStack = cookingPot.getMeal();
        if (!mealStack.method_7960()) {
            if (!cookingPot.doesMealHaveContainer(mealStack)) {
                cookingPot.moveMealToOutput();
                didInventoryChange = true;
            } else if (!cookingPot.inventory.getStackInSlot(7).method_7960()) {
                cookingPot.useStoredContainersOnMeal();
                didInventoryChange = true;
            }
        }
        if (didInventoryChange) {
            cookingPot.inventoryChanged();
        }
    }

    public static void animationTick(class_1937 level, class_2338 pos, class_2680 state, CookingPotBlockEntity cookingPot) {
        if (cookingPot.isHeated(level, pos)) {
            double z;
            double y;
            double x;
            class_5819 random = level.field_9229;
            if (random.method_43057() < 0.2f) {
                x = (double)pos.method_10263() + 0.5 + (random.method_43058() * 0.6 - 0.3);
                y = (double)pos.method_10264() + 0.7;
                z = (double)pos.method_10260() + 0.5 + (random.method_43058() * 0.6 - 0.3);
                level.method_8406((class_2394)class_2398.field_11241, x, y, z, 0.0, 0.0, 0.0);
            }
            if (random.method_43057() < 0.05f) {
                x = (double)pos.method_10263() + 0.5 + (random.method_43058() * 0.4 - 0.2);
                y = (double)pos.method_10264() + 0.5;
                z = (double)pos.method_10260() + 0.5 + (random.method_43058() * 0.4 - 0.2);
                double motionY = random.method_43056() ? 0.015 : 0.005;
                level.method_8406((class_2394)ModParticleTypes.STEAM.get(), x, y, z, 0.0, motionY, 0.0);
            }
        }
    }

    private Optional<class_8786<CookingPotRecipe>> getMatchingRecipe(RecipeWrapper inventoryWrapper, class_3218 level) {
        if (level == null) {
            return Optional.empty();
        }
        return this.hasInput() ? this.quickCheck.method_42303((class_9695)inventoryWrapper, level) : Optional.empty();
    }

    public class_1799 getContainer() {
        class_1799 mealStack = this.getMeal();
        if (!mealStack.method_7960() && !this.mealContainerStack.method_7960()) {
            return this.mealContainerStack;
        }
        return mealStack.getRecipeRemainder();
    }

    private boolean hasInput() {
        for (int i = 0; i < 6; ++i) {
            if (this.inventory.getStackInSlot(i).method_7960()) continue;
            return true;
        }
        return false;
    }

    protected boolean canCook(CookingPotRecipe recipe) {
        if (this.hasInput()) {
            class_1799 resultStack = recipe.assemble(new RecipeWrapper(this.inventory), (class_7225.class_7874)this.field_11863.method_30349());
            if (resultStack.method_7960()) {
                return false;
            }
            class_1799 storedMealStack = this.inventory.getStackInSlot(6);
            if (storedMealStack.method_7960()) {
                return true;
            }
            if (!class_1799.method_7984((class_1799)storedMealStack, (class_1799)resultStack)) {
                return false;
            }
            if (storedMealStack.method_7947() + resultStack.method_7947() <= Math.max(64, storedMealStack.method_7914())) {
                return true;
            }
            return storedMealStack.method_7947() + resultStack.method_7947() <= resultStack.method_7914();
        }
        return false;
    }

    private boolean processCooking(class_8786<CookingPotRecipe> recipe, CookingPotBlockEntity cookingPot) {
        if (this.field_11863 == null) {
            return false;
        }
        ++this.cookTime;
        this.cookTimeTotal = ((CookingPotRecipe)recipe.comp_1933()).getCookTime();
        if (this.cookTime < this.cookTimeTotal) {
            return false;
        }
        this.cookTime = 0;
        this.mealContainerStack = ((CookingPotRecipe)recipe.comp_1933()).container();
        class_1799 resultStack = ((CookingPotRecipe)recipe.comp_1933()).assemble(new RecipeWrapper(this.inventory), (class_7225.class_7874)this.field_11863.method_30349());
        class_1799 storedMealStack = this.inventory.getStackInSlot(6);
        if (storedMealStack.method_7960()) {
            this.inventory.setStackInSlot(6, resultStack.method_7972());
        } else if (class_1799.method_7984((class_1799)storedMealStack, (class_1799)resultStack)) {
            storedMealStack.method_7933(resultStack.method_7947());
        }
        cookingPot.method_7662(recipe);
        for (int i = 0; i < 6; ++i) {
            class_1799 slotStack = this.inventory.getStackInSlot(i);
            if (!slotStack.getRecipeRemainder().method_7960()) {
                this.ejectIngredientRemainder(slotStack.getRecipeRemainder());
            } else if (INGREDIENT_REMAINDER_OVERRIDES.containsKey(slotStack.method_7909())) {
                this.ejectIngredientRemainder(INGREDIENT_REMAINDER_OVERRIDES.get(slotStack.method_7909()).method_7854());
            }
            if (slotStack.method_7960()) continue;
            slotStack.method_7934(1);
        }
        return true;
    }

    protected void ejectIngredientRemainder(class_1799 remainderStack) {
        class_2350 direction = ((class_2350)this.method_11010().method_11654(CookingPotBlock.FACING)).method_10160();
        double x = (double)this.field_11867.method_10263() + 0.5 + (double)direction.method_10148() * 0.25;
        double y = (double)this.field_11867.method_10264() + 0.7;
        double z = (double)this.field_11867.method_10260() + 0.5 + (double)direction.method_10165() * 0.25;
        ItemUtils.spawnItemEntity(this.field_11863, remainderStack, x, y, z, (float)direction.method_10148() * 0.08f, 0.25, (float)direction.method_10165() * 0.08f);
    }

    public void method_7662(@Nullable class_8786<?> recipe) {
        if (recipe != null) {
            class_5321 recipeID = recipe.comp_1932();
            this.usedRecipeTracker.addTo((Object)recipeID, 1);
        }
    }

    @Nullable
    public class_8786<?> method_7663() {
        return null;
    }

    public void method_7664(class_1657 player, List<class_1799> items) {
        class_1937 class_19372 = player.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            List<class_8786<?>> usedRecipes = this.getUsedRecipesAndPopExperience(serverLevel, player.method_73189());
            player.method_7254(usedRecipes);
            this.usedRecipeTracker.clear();
        }
    }

    public List<class_8786<?>> getUsedRecipesAndPopExperience(class_3218 level, class_243 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.usedRecipeTracker.object2IntEntrySet()) {
            level.method_64577().method_8130((class_5321)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                CookingPotBlockEntity.splitAndSpawnExperience(level, pos, entry.getIntValue(), ((CookingPotRecipe)recipe.comp_1933()).getExperience());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(class_3218 level, class_243 pos, int craftedAmount, float experience) {
        int expTotal = class_3532.method_15375((float)((float)craftedAmount * experience));
        float expFraction = class_3532.method_22450((float)((float)craftedAmount * experience));
        if (expFraction != 0.0f && Math.random() < (double)expFraction) {
            ++expTotal;
        }
        class_1303.method_31493((class_3218)level, (class_243)pos, (int)expTotal);
    }

    public boolean isHeated() {
        if (this.field_11863 == null) {
            return false;
        }
        return this.isHeated(this.field_11863, this.field_11867);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public class_1799 getMeal() {
        return this.inventory.getStackInSlot(6);
    }

    public class_2371<class_1799> getDroppableInventory() {
        class_2371 drops = class_2371.method_10211();
        for (int i = 0; i < 9; ++i) {
            if (i == 6) continue;
            drops.add((Object)this.inventory.getStackInSlot(i));
        }
        return drops;
    }

    private void moveMealToOutput() {
        class_1799 mealStack = this.inventory.getStackInSlot(6);
        class_1799 outputStack = this.inventory.getStackInSlot(8);
        int mealCount = Math.min(mealStack.method_7947(), mealStack.method_7914() - outputStack.method_7947());
        if (outputStack.method_7960()) {
            this.inventory.setStackInSlot(8, mealStack.method_7971(mealCount));
        } else if (outputStack.method_7909() == mealStack.method_7909()) {
            mealStack.method_7934(mealCount);
            outputStack.method_7933(mealCount);
        }
    }

    private void useStoredContainersOnMeal() {
        class_1799 mealStack = this.inventory.getStackInSlot(6);
        class_1799 containerInputStack = this.inventory.getStackInSlot(7);
        class_1799 outputStack = this.inventory.getStackInSlot(8);
        if (this.isContainerValid(containerInputStack) && outputStack.method_7947() < outputStack.method_7914()) {
            int smallerStackCount = Math.min(mealStack.method_7947(), containerInputStack.method_7947());
            int mealCount = Math.min(smallerStackCount, mealStack.method_7914() - outputStack.method_7947());
            if (outputStack.method_7960()) {
                containerInputStack.method_7934(mealCount);
                this.inventory.setStackInSlot(8, mealStack.method_7971(mealCount));
            } else if (outputStack.method_7909() == mealStack.method_7909()) {
                mealStack.method_7934(mealCount);
                containerInputStack.method_7934(mealCount);
                outputStack.method_7933(mealCount);
            }
        }
    }

    public class_1799 useHeldItemOnMeal(class_1799 container) {
        if (this.isContainerValid(container) && !this.getMeal().method_7960()) {
            container.method_7934(1);
            return this.getMeal().method_7971(1);
        }
        return class_1799.field_8037;
    }

    private boolean doesMealHaveContainer(class_1799 meal) {
        return !this.mealContainerStack.method_7960() || !meal.getRecipeRemainder().method_7960();
    }

    public boolean isContainerValid(class_1799 containerItem) {
        if (containerItem.method_7960()) {
            return false;
        }
        if (!this.mealContainerStack.method_7960()) {
            return class_1799.method_7984((class_1799)this.mealContainerStack, (class_1799)containerItem);
        }
        return class_1799.method_7984((class_1799)this.getMeal(), (class_1799)containerItem);
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : TextUtils.getTranslation("container.cooking_pot", new Object[0]);
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    public class_1703 createMenu(int id, class_1661 player, class_1657 entity) {
        return new CookingPotMenu(id, player, this, this.cookingPotData);
    }

    @NotNull
    public Storage<ItemVariant> getStorage(@Nullable class_2350 side) {
        if (side == null || side.equals((Object)class_2350.field_11036)) {
            return this.inputHandler;
        }
        return this.outputHandler;
    }

    public void method_11012() {
        super.method_11012();
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 registries) {
        class_2487 var4;
        try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(this.method_71402(), LOGGER);){
            class_11362 tagValueOutput = class_11362.method_71459((class_8942)scopedCollector, (class_7225.class_7874)registries);
            this.writeItems((class_11372)tagValueOutput);
            var4 = tagValueOutput.method_71475();
        }
        return var4;
    }

    protected void method_57568(class_9473 componentInput) {
        super.method_57568(componentInput);
        this.customName = (class_2561)componentInput.method_58694(class_9334.field_49631);
        this.getInventory().setStackInSlot(6, ((ItemStackWrapper)componentInput.method_58695(ModDataComponents.MEAL.get(), (Object)ItemStackWrapper.EMPTY)).getStack());
        this.mealContainerStack = ((ItemStackWrapper)componentInput.method_58695(ModDataComponents.CONTAINER.get(), (Object)ItemStackWrapper.EMPTY)).getStack();
    }

    protected void method_57567(class_9323.class_9324 components) {
        super.method_57567(components);
        components.method_57840(class_9334.field_49631, (Object)this.customName);
        if (!this.getMeal().method_7960()) {
            components.method_57840(ModDataComponents.MEAL.get(), (Object)new ItemStackWrapper(this.getMeal()));
        }
        if (!this.getContainer().method_7960()) {
            components.method_57840(ModDataComponents.CONTAINER.get(), (Object)new ItemStackWrapper(this.getContainer()));
        }
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(9){

            @Override
            protected int getStackLimit(int slot, class_1799 stack) {
                if (slot == 6) {
                    return Math.max(64, stack.method_7914());
                }
                return super.getStackLimit(slot, stack);
            }

            @Override
            protected void onContentsChanged(int slot) {
                CookingPotBlockEntity.this.inventoryChanged();
            }

            @Override
            public IntList getInputSlotIndexes() {
                return IntImmutableList.of((int[])IntStream.range(0, 6).toArray());
            }
        };
    }

    private class_3913 createIntArray() {
        return new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> CookingPotBlockEntity.this.cookTime;
                    case 1 -> CookingPotBlockEntity.this.cookTimeTotal;
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        CookingPotBlockEntity.this.cookTime = value;
                        break;
                    }
                    case 1: {
                        CookingPotBlockEntity.this.cookTimeTotal = value;
                    }
                }
            }

            public int method_17389() {
                return 2;
            }
        };
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.method_11016();
    }
}

