/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.mixin;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.HashSet;
import java.util.Set;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.pipeline.CompositeRenderer;
import net.irisshaders.iris.pipeline.IrisPipelines;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.ShaderKey;
import net.irisshaders.iris.vertices.ImmediateState;
import net.minecraft.class_10799;
import net.minecraft.class_10865;
import net.minecraft.class_10867;
import net.minecraft.class_5944;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_10865.class})
public abstract class MixinShaderManager_Overrides {
    @Unique
    private Set<RenderPipeline> missingShaders = new HashSet<RenderPipeline>();

    @Inject(method={"method_68381(Lcom/mojang/blaze3d/pipeline/RenderPipeline;)Lnet/minecraft/class_10867;"}, at={@At(value="HEAD")}, cancellable=true)
    private void redirectIrisProgram(RenderPipeline renderPipeline, CallbackInfoReturnable<class_10867> cir) {
        IrisRenderingPipeline irisPipeline;
        if (renderPipeline == CompositeRenderer.COMPOSITE_PIPELINE) {
            return;
        }
        if (renderPipeline == class_10799.field_64220 || renderPipeline == class_10799.field_64221) {
            return;
        }
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline instanceof IrisRenderingPipeline && (irisPipeline = (IrisRenderingPipeline)pipeline).shouldOverrideShaders() && !ImmediateState.bypass) {
            RenderPipeline newProgram = renderPipeline;
            class_5944 program = MixinShaderManager_Overrides.override(irisPipeline, newProgram);
            if (program != null) {
                cir.setReturnValue((Object)new class_10867(renderPipeline, program));
            } else if (this.missingShaders.add(renderPipeline)) {
                if (renderPipeline.getLocation().method_12836().equals("minecraft")) {
                    Iris.logger.fatal("Missing program " + String.valueOf(renderPipeline.getLocation()) + " in override list. This is likely an Iris bug!!!", new Throwable());
                } else {
                    Iris.logger.error("Missing program " + String.valueOf(renderPipeline.getLocation()) + " in override list. This is not a critical problem, but it could lead to weird rendering.", new Throwable());
                }
            }
        }
    }

    private static class_5944 override(IrisRenderingPipeline pipeline, RenderPipeline shaderProgram) {
        ShaderKey shaderKey = IrisPipelines.getPipeline(pipeline, shaderProgram);
        return shaderKey == null ? null : pipeline.getShaderMap().getShader(shaderKey);
    }
}

